/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NiftyInputControl {
    @Nonnull
    private final Controller controller;
    @Nonnull
    private final NiftyInputMapping inputMapper;
    @Nonnull
    private final List<KeyInputHandler> preInputHandler = new ArrayList<KeyInputHandler>();
    @Nonnull
    private final List<KeyInputHandler> postInputHandler = new ArrayList<KeyInputHandler>();

    public NiftyInputControl(@Nonnull Controller controllerParam, @Nonnull NiftyInputMapping inputMapperParam) {
        this.controller = controllerParam;
        this.inputMapper = inputMapperParam;
    }

    public boolean keyEvent(@Nonnull Nifty nifty, @Nonnull KeyboardInputEvent inputEvent, @Nonnull String elementId) {
        NiftyInputEvent converted = this.inputMapper.convert(inputEvent);
        if (converted == null) {
            return false;
        }
        for (KeyInputHandler handler : this.preInputHandler) {
            if (!handler.keyEvent(converted)) continue;
            return true;
        }
        nifty.publishEvent(elementId, converted);
        if (this.controller.inputEvent(converted)) {
            return true;
        }
        for (KeyInputHandler handler : this.postInputHandler) {
            if (!handler.keyEvent(converted)) continue;
            return true;
        }
        return false;
    }

    public void addInputHandler(@Nonnull KeyInputHandler handler) {
        this.postInputHandler.add(handler);
    }

    public void addPreInputHandler(@Nonnull KeyInputHandler handler) {
        this.preInputHandler.add(handler);
    }

    public void onStartScreen(@Nonnull Nifty nifty, @Nonnull Screen screen) {
        this.controller.onStartScreen();
    }

    public void onEndScreen(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nullable String elementId) {
        this.controller.onEndScreen();
        nifty.unsubscribeAnnotations(this.controller);
        if (elementId != null) {
            nifty.unsubscribeElement(screen, elementId);
        }
    }

    public void onFocus(boolean getFocus) {
        this.controller.onFocus(getFocus);
    }

    @Nonnull
    public Controller getController() {
        return this.controller;
    }

    @Nullable
    public <T extends Controller> T getControl(@Nonnull Class<T> requestedControlClass) {
        if (requestedControlClass.isInstance(this.controller)) {
            return (T)((Controller)requestedControlClass.cast(this.controller));
        }
        return null;
    }

    @Nullable
    public <T extends NiftyControl> T getNiftyControl(@Nonnull Class<T> requestedControlClass) {
        if (requestedControlClass.isInstance(this.controller)) {
            return (T)((NiftyControl)requestedControlClass.cast(this.controller));
        }
        return null;
    }

    public void bindControl(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Attributes attributes) {
        this.controller.bind(nifty, screen, element, new Parameters(attributes.createProperties()));
    }

    public void initControl(@Nonnull Attributes attributes) {
        this.controller.init(new Parameters(attributes.createProperties()));
    }
}

