/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.resolution;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.DropDownSelectionChangedEvent;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.examples.resolution.ResolutionControl;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResolutionScreen<T>
implements ScreenController,
NiftyExample {
    private Nifty nifty;
    @Nullable
    private DropDown<T> dropDown;
    private ResolutionControl<T> resControl;

    public ResolutionScreen(ResolutionControl<T> newControl) {
        this.resControl = newControl;
    }

    public void bind(@Nonnull Nifty newNifty, @Nonnull Screen screen) {
        this.nifty = newNifty;
        this.dropDown = (DropDown)screen.findNiftyControl("resolutions", DropDown.class);
        ListBox listBox = (ListBox)screen.findNiftyControl("listBox", ListBox.class);
        this.fillResolutionDropDown(screen);
        this.dropDown.selectItem(this.resControl.getCurrentResolution());
        listBox.addItem((Object)"Test");
        listBox.addItem((Object)"TestTestTestTestTestTestTestTestTestTestTestTest");
        listBox.selectItem((Object)"Test");
    }

    public void onStartScreen() {
    }

    public void onEndScreen() {
    }

    @NiftyEventSubscriber(id="resolutions")
    public void onResolution(String id, @Nonnull DropDownSelectionChangedEvent<T> event) {
        this.resControl.setResolution(event.getSelection());
        this.nifty.resolutionChanged();
    }

    private void fillResolutionDropDown(Screen screen) {
        Collection<T> resolutions = this.resControl.getResolutions();
        for (T mode : resolutions) {
            this.dropDown.addItem(mode);
        }
    }

    @Override
    @Nonnull
    public String getStartScreen() {
        return "start";
    }

    @Override
    @Nonnull
    public String getMainXML() {
        return "resolution/resolution.xml";
    }

    @Override
    @Nonnull
    public String getTitle() {
        return "Nifty Screen Resolution";
    }

    @Override
    public void prepareStart(@Nonnull Nifty nifty) {
        nifty.registerScreenController(new ScreenController[]{this});
    }
}

