/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.progressbar;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProgressbarControl
implements Controller,
NiftyExample {
    @Nullable
    private Element progressBarElement;
    @Nullable
    private Element progressTextElement;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screenParam, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.progressBarElement = element.findElementById("#progress");
        this.progressTextElement = element.findElementById("#progress-text");
    }

    public void init(@Nonnull Parameters parameter) {
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void onEndScreen() {
    }

    public void setProgress(float progressValue) {
        float progress = progressValue;
        if (progress < 0.0f) {
            progress = 0.0f;
        } else if (progress > 1.0f) {
            progress = 1.0f;
        }
        int MIN_WIDTH = 32;
        int pixelWidth = (int)(32.0f + (float)(this.progressBarElement.getParent().getWidth() - 32) * progress);
        this.progressBarElement.setConstraintWidth(new SizeValue(pixelWidth + "px"));
        this.progressBarElement.getParent().layoutElements();
        String progressText = String.format("%3.0f%%", Float.valueOf(progress * 100.0f));
        ((TextRenderer)this.progressTextElement.getRenderer(TextRenderer.class)).setText(progressText);
    }

    @Override
    @Nonnull
    public String getStartScreen() {
        return "start";
    }

    @Override
    @Nonnull
    public String getMainXML() {
        return "progressbar/progressbar.xml";
    }

    @Override
    @Nonnull
    public String getTitle() {
        return "Nifty Progressbar Example";
    }

    @Override
    public void prepareStart(Nifty nifty) {
    }
}

