/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.multiclick;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.label.builder.LabelBuilder;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryClickedEvent;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultiClickExample
implements ScreenController,
NiftyExample {
    private Nifty nifty;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen) {
        this.nifty = nifty;
        nifty.setGlobalProperties(new Properties());
        nifty.getGlobalProperties().setProperty("MULTI_CLICK_TIME", "200");
        Element findElementById = screen.findElementById("GPanel3");
        new LabelBuilder("GLabel2"){
            {
                this.text("This is generated using builder");
                this.wrap(true);
                this.height(SizeValue.wildcard());
                this.width(SizeValue.wildcard());
                this.interactOnMultiClick("changeTime()");
            }
        }.build(nifty, screen, findElementById);
    }

    public void onStartScreen() {
    }

    public void onEndScreen() {
    }

    public void log(int x, int y, int count) {
        System.out.println("clicked: " + count);
        Label findNiftyControl = (Label)this.nifty.getCurrentScreen().findNiftyControl("GLabel0", Label.class);
        findNiftyControl.setText("Click count: " + count);
    }

    @NiftyEventSubscriber(id="GLabel0")
    public void logSingle(String id, NiftyMousePrimaryClickedEvent event) {
        System.out.println("Click one time");
    }

    public void changeTime() {
        Properties globalProperties = this.nifty.getGlobalProperties();
        String property = globalProperties.getProperty("MULTI_CLICK_TIME");
        int time = Integer.parseInt(property);
        if ((time += 100) > 1500) {
            time = 200;
        }
        globalProperties.setProperty("MULTI_CLICK_TIME", "" + time);
        System.out.println("New time : " + time);
    }

    @Override
    public String getStartScreen() {
        return "start";
    }

    @Override
    @Nullable
    public String getMainXML() {
        return "multiclick/mainscreen.xml";
    }

    @Override
    @Nonnull
    public String getTitle() {
        return "Multiclick Example";
    }

    @Override
    public void prepareStart(Nifty nifty) {
    }
}

