/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.dragndrop;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.NiftyIdCreator;
import de.lessvoid.nifty.builder.TextBuilder;
import de.lessvoid.nifty.controls.Draggable;
import de.lessvoid.nifty.controls.DraggableDragCanceledEvent;
import de.lessvoid.nifty.controls.DraggableDragStartedEvent;
import de.lessvoid.nifty.controls.Droppable;
import de.lessvoid.nifty.controls.DroppableDropFilter;
import de.lessvoid.nifty.controls.DroppableDroppedEvent;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.WindowClosedEvent;
import de.lessvoid.nifty.controls.dragndrop.builder.DraggableBuilder;
import de.lessvoid.nifty.controls.window.builder.WindowBuilder;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DragDropScreen
implements ScreenController,
NiftyExample {
    private Nifty nifty;
    private Screen screen;
    @Nonnull
    private final Random random = new Random();
    @Nullable
    private Droppable trash;
    @Nullable
    private Droppable evilStuff;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen) {
        this.nifty = nifty;
        this.screen = screen;
        this.trash = this.findDroppable("Trash");
        Droppable goodStuff = this.findDroppable("GoodStuff");
        this.evilStuff = this.findDroppable("EvilStuff");
        goodStuff.addFilter(new DroppableDropFilter(){

            public boolean accept(@Nullable Droppable source, @Nonnull Draggable draggable, @Nonnull Droppable target) {
                return source != DragDropScreen.this.evilStuff;
            }
        });
    }

    public void onStartScreen() {
    }

    public void onEndScreen() {
    }

    public final void quit() {
        this.nifty.setAlternateKeyForNextLoadXml("fade");
        this.nifty.fromXml("all/intro.xml", "menu");
    }

    public void spawnDraggable() {
        DraggableBuilder builder = new DraggableBuilder(){
            {
                this.width("120px");
                this.height("120px");
                this.backgroundColor(DragDropScreen.this.randomColor());
                this.childLayoutCenter();
                this.valignTop();
                this.text(new TextBuilder(){
                    {
                        this.text("Drag Me!");
                        this.style("descriptionText");
                    }
                });
            }
        };
        Element draggables = this.screen.findElementById("draggables");
        if (draggables != null) {
            builder.build(this.nifty, this.screen, draggables);
        }
    }

    public void spawnWindow() {
        Element windows = this.screen.findElementById("windows");
        if (windows == null) {
            throw new IllegalStateException("Window parent control not found.");
        }
        String windowId = NiftyIdCreator.generate() + 1000;
        WindowBuilder windowBuilder = new WindowBuilder("window-" + windowId, "New Window [" + windowId + "]");
        windowBuilder.width("360px");
        windowBuilder.height("240px");
        windowBuilder.build(this.nifty, this.screen, windows);
    }

    @NiftyEventSubscriber(pattern="window-.*")
    public void onAnyWindowClose(String id, @Nonnull WindowClosedEvent event) {
        this.setStatus("Window [" + id + "] " + (event.isHidden() ? "hidden" : "closed"));
    }

    @Nonnull
    private String randomColor() {
        return "#" + Integer.toHexString(this.random.nextInt(200)) + Integer.toHexString(this.random.nextInt(200)) + Integer.toHexString(this.random.nextInt(200)) + "ff";
    }

    @NiftyEventSubscriber(pattern=".*")
    public void showDragStartStatus(String id, @Nonnull DraggableDragStartedEvent event) {
        this.setStatus("Dragging [" + this.getId(event.getDraggable()) + "] from [" + this.getId(event.getSource()) + "].");
    }

    @NiftyEventSubscriber(pattern=".*")
    public void showDragCancelStatus(String id, @Nonnull DraggableDragCanceledEvent event) {
        this.setStatus("Canceled [" + this.getId(event.getDraggable()) + "] reverting back to [" + this.getId(event.getSource()) + "].");
    }

    @NiftyEventSubscriber(pattern=".*")
    public void showDropStatus(String id, @Nonnull DroppableDroppedEvent event) {
        if (event.getTarget() == this.trash && event.getSource() == this.evilStuff) {
            this.setStatus("Evil [" + this.getId(event.getDraggable()) + "] has been eliminated.");
        } else if (event.getTarget() == this.evilStuff) {
            this.setStatus("[" + this.getId(event.getDraggable()) + "] has become evil");
        } else {
            this.setStatus("Dropped [" + this.getId(event.getDraggable()) + "] on [" + this.getId(event.getTarget()) + "].");
        }
    }

    @NiftyEventSubscriber(id="Trash")
    public void onTrashDrop(String id, @Nonnull DroppableDroppedEvent event) {
        event.getDraggable().getElement().markForRemoval();
    }

    @Nullable
    private String getId(@Nullable Droppable droppable) {
        return droppable != null ? droppable.getElement().getId() : null;
    }

    @Nullable
    private String getId(@Nullable Draggable draggable) {
        return draggable != null ? draggable.getElement().getId() : null;
    }

    private void setStatus(String text) {
        Label status = (Label)this.screen.findNiftyControl("status", Label.class);
        if (status != null) {
            status.setText(text);
        }
    }

    @Nonnull
    private Droppable findDroppable(String id) {
        Droppable droppable = (Droppable)this.screen.findNiftyControl(id, Droppable.class);
        if (droppable == null) {
            throw new IllegalArgumentException("Requested id " + id + " does not match a droppable.");
        }
        return droppable;
    }

    @Override
    @Nonnull
    public String getStartScreen() {
        return "start";
    }

    @Override
    @Nonnull
    public String getMainXML() {
        return "dragndrop/dragndrop.xml";
    }

    @Override
    @Nonnull
    public String getTitle() {
        return "Nifty Drag'n'Drop Example";
    }

    @Override
    public void prepareStart(Nifty nifty) {
    }
}

