/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.sliderandscrollbar;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.Scrollbar;
import de.lessvoid.nifty.controls.ScrollbarChangedEvent;
import de.lessvoid.nifty.controls.Slider;
import de.lessvoid.nifty.controls.SliderChangedEvent;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.TextFieldChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.PanelRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliderAndScrollbarDialogController
implements Controller {
    private Screen screen;
    @Nullable
    private Element color;
    private float red;
    private float green;
    private float blue;
    private float alpha;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.screen = screen;
        this.color = screen.findElementById("color");
        this.red = 0.0f;
        this.green = 0.0f;
        this.blue = 0.0f;
    }

    public void init(@Nonnull Parameters parameter) {
    }

    public void onStartScreen() {
        this.getSlider("sliderR").setup(0.0f, 255.0f, 0.0f, 1.0f, 10.0f);
        this.getSlider("sliderG").setup(0.0f, 255.0f, 0.0f, 1.0f, 10.0f);
        this.getSlider("sliderB").setup(0.0f, 255.0f, 0.0f, 1.0f, 10.0f);
        this.getSlider("sliderA").setup(0.0f, 255.0f, 255.0f, 1.0f, 10.0f);
        this.getScrollbar("scrollbarH").setWorldMax(1000.0f);
        this.getScrollbar("scrollbarH").setWorldPageSize(10.0f);
        this.getTextfield("scrollbarH_WorldMax_Textfield").setText((CharSequence)String.valueOf((int)this.getScrollbar("scrollbarH").getWorldMax()));
        this.getTextfield("scrollbarH_CurrentValue_Textfield").setText((CharSequence)String.valueOf((int)this.getScrollbar("scrollbarH").getValue()));
        this.getTextfield("scrollbarH_ViewMax_Textfield").setText((CharSequence)String.valueOf((int)this.getScrollbar("scrollbarH").getWorldPageSize()));
        this.getTextfield("scrollbarH_ButtonStepSize_Textfield").setText((CharSequence)String.valueOf((int)this.getScrollbar("scrollbarH").getButtonStepSize()));
        this.getTextfield("scrollbarH_PageStepSize_Textfield").setText((CharSequence)String.valueOf((int)this.getScrollbar("scrollbarH").getPageStepSize()));
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void onEndScreen() {
    }

    @NiftyEventSubscriber(id="sliderR")
    public void onRedSliderChange(String id, @Nonnull SliderChangedEvent event) {
        this.red = event.getValue();
        this.changeColor();
    }

    @NiftyEventSubscriber(id="sliderG")
    public void onGreenSliderChange(String id, @Nonnull SliderChangedEvent event) {
        this.green = event.getValue();
        this.changeColor();
    }

    @NiftyEventSubscriber(id="sliderB")
    public void onBlueSliderChange(String id, @Nonnull SliderChangedEvent event) {
        this.blue = event.getValue();
        this.changeColor();
    }

    @NiftyEventSubscriber(id="sliderA")
    public void onAlphaSliderChange(String id, @Nonnull SliderChangedEvent event) {
        this.alpha = event.getValue();
        this.changeColor();
    }

    @NiftyEventSubscriber(id="scrollbarH")
    public void onScrollbarHChanged(String id, ScrollbarChangedEvent event) {
        this.getTextfield("scrollbarH_CurrentValue_Textfield").setText((CharSequence)String.valueOf(this.getScrollbar("scrollbarH").getValue()));
    }

    @NiftyEventSubscriber(id="scrollbarH_WorldMax_Textfield")
    public void onMaxValueChanged(String id, @Nonnull TextFieldChangedEvent event) {
        try {
            float f = Float.valueOf(event.getText()).floatValue();
            Scrollbar scrollbar = this.getScrollbar("scrollbarH");
            scrollbar.setWorldMax(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @NiftyEventSubscriber(id="scrollbarH_ViewMax_Textfield")
    public void onViewMaxValueChanged(String id, @Nonnull TextFieldChangedEvent event) {
        try {
            float f = Float.valueOf(event.getText()).floatValue();
            Scrollbar scrollbar = this.getScrollbar("scrollbarH");
            scrollbar.setWorldPageSize(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @NiftyEventSubscriber(id="scrollbarH_CurrentValue_Textfield")
    public void onCurrentValueChanged(String id, @Nonnull TextFieldChangedEvent event) {
        try {
            float f = Float.valueOf(event.getText()).floatValue();
            Scrollbar scrollbar = this.getScrollbar("scrollbarH");
            scrollbar.setValue(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @NiftyEventSubscriber(id="scrollbarH_ButtonStepSize_Textfield")
    public void onButtonStepSizeChanged(String id, @Nonnull TextFieldChangedEvent event) {
        try {
            float f = Float.valueOf(event.getText()).floatValue();
            Scrollbar scrollbar = this.getScrollbar("scrollbarH");
            scrollbar.setButtonStepSize(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @NiftyEventSubscriber(id="scrollbarH_PageStepSize_Textfield")
    public void onPageStepSizeChanged(String id, @Nonnull TextFieldChangedEvent event) {
        try {
            float f = Float.valueOf(event.getText()).floatValue();
            Scrollbar scrollbar = this.getScrollbar("scrollbarH");
            scrollbar.setPageStepSize(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void changeColor() {
        ((PanelRenderer)this.color.getRenderer(PanelRenderer.class)).setBackgroundColor(new Color(this.red / 255.0f, this.green / 255.0f, this.blue / 255.0f, this.alpha / 255.0f));
        this.getLabel("redLabel").setText(String.valueOf((int)this.red));
        this.getLabel("greenLabel").setText(String.valueOf((int)this.green));
        this.getLabel("blueLabel").setText(String.valueOf((int)this.blue));
        this.getLabel("alphaLabel").setText(String.valueOf((int)this.alpha));
    }

    @Nullable
    private Slider getSlider(String id) {
        return (Slider)this.screen.findNiftyControl(id, Slider.class);
    }

    @Nullable
    private Scrollbar getScrollbar(String id) {
        return (Scrollbar)this.screen.findNiftyControl(id, Scrollbar.class);
    }

    @Nullable
    private TextField getTextfield(String id) {
        return (TextField)this.screen.findNiftyControl(id, TextField.class);
    }

    @Nullable
    private Label getLabel(String id) {
        return (Label)this.screen.findNiftyControl(id, Label.class);
    }
}

