/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.common;

import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.PanelBuilder;
import de.lessvoid.nifty.controls.label.builder.LabelBuilder;
import javax.annotation.Nonnull;

public class CommonBuilders {
    @Nonnull
    public EffectBuilder createMoveEffect(final @Nonnull String mode, final @Nonnull String direction, final int length) {
        return new EffectBuilder("move"){
            {
                super(arg0);
                this.effectParameter("mode", mode);
                this.effectParameter("direction", direction);
                this.effectParameter("timeType", "exp");
                this.effectParameter("factor", "3.5");
                this.length(length);
                this.startDelay(0);
                this.inherit(true);
            }
        };
    }

    @Nonnull
    public EffectBuilder createFadeEffect() {
        return new EffectBuilder("fade"){
            {
                this.effectParameter("start", "#f");
                this.effectParameter("end", "#0");
                this.length(300);
                this.startDelay(300);
                this.inherit(true);
            }
        };
    }

    @Nonnull
    public PanelBuilder vspacer() {
        return new PanelBuilder(){
            {
                this.childLayoutHorizontal();
                this.height("9px");
                this.width("0px");
            }
        };
    }

    @Nonnull
    public PanelBuilder vspacer(final @Nonnull String height) {
        return new PanelBuilder(){
            {
                this.childLayoutHorizontal();
                this.height(height);
                this.width("100%");
            }
        };
    }

    @Nonnull
    public PanelBuilder hspacer(final @Nonnull String width) {
        return new PanelBuilder(){
            {
                this.width(width);
                this.height("0px");
            }
        };
    }

    @Nonnull
    public LabelBuilder createLabel(@Nonnull String text) {
        return this.createLabel(text, "100px");
    }

    @Nonnull
    public LabelBuilder createLabel(final @Nonnull String text, final @Nonnull String width) {
        return new LabelBuilder(){
            {
                this.text(text);
                this.width(width);
                this.alignLeft();
                this.textVAlignCenter();
                this.textHAlignLeft();
            }
        };
    }

    @Nonnull
    public LabelBuilder createLabel(@Nonnull String id, @Nonnull String text, final @Nonnull String width) {
        return new LabelBuilder(id, text){
            {
                super(arg0, arg1);
                this.width(width);
                this.alignLeft();
                this.textVAlignCenter();
                this.textHAlignLeft();
            }
        };
    }

    @Nonnull
    public LabelBuilder createShortLabel(@Nonnull String name, @Nonnull String width) {
        LabelBuilder result = this.createShortLabel(name);
        result.width(width);
        return result;
    }

    @Nonnull
    public LabelBuilder createShortLabel(final @Nonnull String name) {
        return new LabelBuilder(){
            {
                this.text(name);
                this.alignLeft();
                this.textVAlignCenter();
                this.textHAlignLeft();
            }
        };
    }
}

