/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.console;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleExecuteCommandEvent;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.input.mapping.DefaultInputMapping;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConsoleSameScreenStartScreen
implements ScreenController,
KeyInputHandler,
NiftyExample {
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    private boolean consoleVisible = false;
    private boolean allowConsoleToggle = true;
    @Nullable
    private Element oldFocusElement;
    @Nullable
    private Element consoleElementFocus;
    @Nullable
    private Element consoleLayer;

    public void bind(@Nonnull Nifty newNifty, @Nonnull Screen newScreen) {
        this.nifty = newNifty;
        this.screen = newScreen;
        this.screen.addKeyboardInputHandler((NiftyInputMapping)new DefaultInputMapping(), (KeyInputHandler)this);
        Element consoleElement = this.screen.findElementById("console");
        if (consoleElement != null) {
            this.consoleElementFocus = consoleElement.findElementById("#textInput");
        }
        this.consoleLayer = this.screen.findElementById("consoleLayer");
    }

    public void onStartScreen() {
        this.removeConsoleElementFromFocusHandler();
    }

    public void onEndScreen() {
    }

    public void back() {
        if (this.nifty != null) {
            this.nifty.fromXml("all/intro.xml", "menu");
        }
    }

    public boolean keyEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyStandardInputEvent.ConsoleToggle) {
            this.toggleConsole();
            return true;
        }
        return false;
    }

    @NiftyEventSubscriber(id="console")
    public void onConsoleCommand(String id, @Nonnull ConsoleExecuteCommandEvent command) {
        if (this.screen == null) {
            return;
        }
        Console console = (Console)this.screen.findNiftyControl("console", Console.class);
        if (console != null) {
            console.output("your input was: " + command.getCommandLine() + " [" + command.getArgumentCount() + " parameter(s)]");
        }
        if ("exit".equals(command.getCommand())) {
            this.back();
        }
    }

    private void toggleConsole() {
        if (this.allowConsoleToggle) {
            this.allowConsoleToggle = false;
            if (this.consoleVisible) {
                this.closeConsole();
            } else {
                this.openConsole();
            }
        }
    }

    private void openConsole() {
        if (this.consoleLayer != null && this.screen != null && this.consoleElementFocus != null) {
            this.consoleLayer.showWithoutEffects();
            this.consoleLayer.startEffect(EffectEventId.onStartScreen, new EndNotify(){

                public void perform() {
                    ConsoleSameScreenStartScreen.this.oldFocusElement = ConsoleSameScreenStartScreen.this.screen.getFocusHandler().getKeyboardFocusElement();
                    ConsoleSameScreenStartScreen.this.addConsoleElementToFocusHandler();
                    ConsoleSameScreenStartScreen.this.consoleElementFocus.setFocus();
                    ConsoleSameScreenStartScreen.this.consoleVisible = true;
                    ConsoleSameScreenStartScreen.this.allowConsoleToggle = true;
                }
            });
        }
    }

    private void closeConsole() {
        if (this.consoleLayer != null) {
            this.consoleLayer.startEffect(EffectEventId.onEndScreen, new EndNotify(){

                public void perform() {
                    ConsoleSameScreenStartScreen.this.consoleLayer.hideWithoutEffect();
                    ConsoleSameScreenStartScreen.this.consoleVisible = false;
                    ConsoleSameScreenStartScreen.this.allowConsoleToggle = true;
                    if (ConsoleSameScreenStartScreen.this.oldFocusElement != null) {
                        ConsoleSameScreenStartScreen.this.oldFocusElement.setFocus();
                    }
                    ConsoleSameScreenStartScreen.this.removeConsoleElementFromFocusHandler();
                }
            });
        }
    }

    private void addConsoleElementToFocusHandler() {
        String id;
        String string = id = this.consoleElementFocus == null ? null : this.consoleElementFocus.getId();
        if (id == null) {
            return;
        }
        if (this.screen != null && this.screen.getFocusHandler().findElement(id) == null) {
            this.screen.getFocusHandler().addElement(this.consoleElementFocus);
        }
    }

    private void removeConsoleElementFromFocusHandler() {
        if (this.screen != null) {
            this.screen.getFocusHandler().remove(this.consoleElementFocus);
        }
    }

    @Override
    @Nonnull
    public String getStartScreen() {
        return "start";
    }

    @Override
    @Nonnull
    public String getMainXML() {
        return "console/console-samescreen.xml";
    }

    @Override
    @Nonnull
    public String getTitle() {
        return "Nifty Console Same Screen Demonstation";
    }

    @Override
    public void prepareStart(Nifty nifty) {
    }
}

