/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javax.annotation.Nonnull;

public class LoggerShortFormat
extends Formatter {
    @Override
    @Nonnull
    public String format(@Nonnull LogRecord record) {
        return record.getMillis() + " " + record.getLevel() + " [" + record.getSourceClassName() + "] " + record.getMessage() + (record.getThrown() != null ? " Stack trace:\n" + this.getStackTrace(record.getThrown()) : "") + "\n";
    }

    public static void intialize() throws Exception {
        InputStream input = null;
        try {
            input = LoggerShortFormat.class.getClassLoader().getResourceAsStream("logging.properties");
            LogManager.getLogManager().readConfiguration(input);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    private String getStackTrace(@Nonnull Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }
}

