/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.treebox;

import de.lessvoid.nifty.controls.TreeItem;
import de.lessvoid.nifty.controls.listbox.ListBoxItemController;
import de.lessvoid.nifty.controls.treebox.TreeBoxControl;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TreeBoxItemController<T>
extends ListBoxItemController<TreeItem<T>> {
    @Nonnull
    private static final Logger log = Logger.getLogger(TreeBoxItemController.class.getName());
    @Nullable
    private TreeBoxControl<T> parentControl;

    void setParentControl(@Nonnull TreeBoxControl<T> control) {
        this.parentControl = control;
    }

    public void expandButtonClicked() {
        if (this.parentControl == null) {
            log.warning("Can't handle click to expend button as long as the parent control is not applied.");
            return;
        }
        TreeItem item = (TreeItem)this.getItem();
        if (item == null || item.isLeaf()) {
            return;
        }
        item.setExpanded(!item.isExpanded());
        this.parentControl.updateList(item);
    }
}

