/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.textfield;

import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TextFieldInputMapping
implements NiftyInputMapping {
    @Nullable
    public NiftyStandardInputEvent convert(@Nonnull KeyboardInputEvent inputEvent) {
        if (inputEvent.isKeyDown()) {
            return TextFieldInputMapping.handleKeyDownEvent(inputEvent);
        }
        return TextFieldInputMapping.handleKeyUpEvent(inputEvent);
    }

    @Nullable
    private static NiftyStandardInputEvent handleKeyDownEvent(@Nonnull KeyboardInputEvent inputEvent) {
        switch (inputEvent.getKey()) {
            case 200: {
                return NiftyStandardInputEvent.MoveCursorUp;
            }
            case 208: {
                return NiftyStandardInputEvent.MoveCursorDown;
            }
            case 203: {
                return NiftyStandardInputEvent.MoveCursorLeft;
            }
            case 205: {
                return NiftyStandardInputEvent.MoveCursorRight;
            }
            case 59: {
                return NiftyStandardInputEvent.ConsoleToggle;
            }
            case 28: {
                return NiftyStandardInputEvent.SubmitText;
            }
            case 211: {
                return NiftyStandardInputEvent.Delete;
            }
            case 14: {
                return NiftyStandardInputEvent.Backspace;
            }
            case 207: {
                return NiftyStandardInputEvent.MoveCursorToLastPosition;
            }
            case 199: {
                return NiftyStandardInputEvent.MoveCursorToFirstPosition;
            }
            case 42: 
            case 54: {
                return NiftyStandardInputEvent.SelectionStart;
            }
            case 15: {
                return inputEvent.isShiftDown() ? NiftyStandardInputEvent.PrevInputElement : NiftyStandardInputEvent.NextInputElement;
            }
            case 45: {
                if (!inputEvent.isControlDown()) break;
                return NiftyStandardInputEvent.Cut;
            }
            case 46: {
                if (!inputEvent.isControlDown()) break;
                return NiftyStandardInputEvent.Copy;
            }
            case 47: {
                if (!inputEvent.isControlDown()) break;
                return NiftyStandardInputEvent.Paste;
            }
            case 30: {
                if (!inputEvent.isControlDown()) break;
                return NiftyStandardInputEvent.SelectAll;
            }
        }
        if (!Character.isISOControl(inputEvent.getCharacter())) {
            NiftyStandardInputEvent character = NiftyStandardInputEvent.Character;
            character.setCharacter(inputEvent.getCharacter());
            return character;
        }
        return null;
    }

    @Nullable
    private static NiftyStandardInputEvent handleKeyUpEvent(@Nonnull KeyboardInputEvent inputEvent) {
        switch (inputEvent.getKey()) {
            case 42: 
            case 54: {
                return NiftyStandardInputEvent.SelectionEnd;
            }
            case 1: {
                return NiftyStandardInputEvent.Escape;
            }
        }
        return null;
    }
}

