/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.scrollpanel;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.ScrollPanel;
import de.lessvoid.nifty.controls.ScrollPanelChangedEvent;
import de.lessvoid.nifty.controls.Scrollbar;
import de.lessvoid.nifty.controls.ScrollbarChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class ScrollPanelControl
extends AbstractController
implements ScrollPanel {
    @Nonnull
    private static final Logger log = Logger.getLogger(ScrollPanelControl.class.getName());
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    private boolean verticalScrollbar;
    private boolean horizontalScrollbar;
    @Nullable
    private Element childRootElement;
    private float stepSizeX;
    private float stepSizeY;
    private float pageSizeX;
    private float pageSizeY;
    @Nonnull
    private ScrollPanel.AutoScroll autoScroll = ScrollPanel.AutoScroll.OFF;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.bind(element);
        this.nifty = nifty;
        this.screen = screen;
        this.verticalScrollbar = parameter.getAsBoolean("vertical", true);
        this.horizontalScrollbar = parameter.getAsBoolean("horizontal", true);
        String childRootId = parameter.get("childRootId");
        if (childRootId == null) {
            log.severe("Missing children root id. This scroll panel will not work.");
        } else {
            this.childRootElement = element.findElementById(childRootId);
        }
        this.stepSizeX = parameter.getAsFloat("stepSizeX", 1.0f);
        this.stepSizeY = parameter.getAsFloat("stepSizeY", 1.0f);
        this.pageSizeX = parameter.getAsFloat("pageSizeX", 1.0f);
        this.pageSizeY = parameter.getAsFloat("pageSizeY", 1.0f);
        this.autoScroll = ScrollPanel.AutoScroll.OFF;
        String autoScrollParam = parameter.get("autoScroll");
        if (autoScrollParam != null) {
            for (ScrollPanel.AutoScroll value : ScrollPanel.AutoScroll.values()) {
                if (!autoScrollParam.equals(value.getParam())) continue;
                this.autoScroll = value;
                break;
            }
        }
    }

    public void init(@Nonnull Parameters parameter) {
        String id;
        Element scrollbarH;
        String id2;
        super.init(parameter);
        if (this.nifty == null || this.screen == null) {
            log.severe("Binding of control is not done. Can't initialize.");
            return;
        }
        this.initializeScrollPanel(this.nifty, this.screen);
        this.initializeScrollbars();
        Element scrollbarV = this.getVerticalScrollbar();
        if (scrollbarV != null && (id2 = scrollbarV.getId()) != null) {
            this.nifty.subscribe(this.screen, id2, ScrollbarChangedEvent.class, (EventTopicSubscriber)new VerticalEventTopicSubscriber(this));
        }
        if ((scrollbarH = this.getHorizontalScrollbar()) != null && (id = scrollbarH.getId()) != null) {
            this.nifty.subscribe(this.screen, id, ScrollbarChangedEvent.class, (EventTopicSubscriber)new HorizontalEventTopicSubscriber(this));
        }
    }

    public void onStartScreen() {
    }

    public void layoutCallback() {
        if (this.childRootElement != null) {
            List elements = this.childRootElement.getChildren();
            if (elements.isEmpty()) {
                return;
            }
            Element scrollElement = (Element)elements.get(0);
            if (scrollElement != null) {
                Scrollbar verticalS;
                Scrollbar horizontalS = this.getHorizontalScrollbarControl();
                if (horizontalS != null) {
                    horizontalS.setWorldMax(scrollElement.getWidth());
                    horizontalS.setWorldPageSize(horizontalS.getWidth());
                    this.updateWorldH();
                }
                if ((verticalS = this.getVerticalScrollbarControl()) != null) {
                    verticalS.setWorldMax(scrollElement.getHeight());
                    verticalS.setWorldPageSize(verticalS.getHeight());
                    this.updateWorldV();
                }
            }
        }
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    @Override
    public void setHorizontalPos(float xPos) {
        Scrollbar horizontalS = this.getHorizontalScrollbarControl();
        if (horizontalS != null && this.verticalScrollbar) {
            horizontalS.setValue(xPos);
        }
    }

    @Override
    public float getHorizontalPos() {
        Scrollbar horizontalS = this.getHorizontalScrollbarControl();
        if (horizontalS != null && this.verticalScrollbar) {
            return horizontalS.getValue();
        }
        return 0.0f;
    }

    @Override
    public void setVerticalPos(float yPos) {
        Scrollbar verticalS = this.getVerticalScrollbarControl();
        if (verticalS != null && this.verticalScrollbar) {
            verticalS.setValue(yPos);
        }
    }

    @Override
    public float getVerticalPos() {
        Scrollbar verticalS = this.getVerticalScrollbarControl();
        if (verticalS != null && this.verticalScrollbar) {
            return verticalS.getValue();
        }
        return 0.0f;
    }

    @Override
    public void showElementVertical(int elemCount) {
        this.showElementVertical(elemCount, ScrollPanel.VerticalAlign.center);
    }

    @Override
    public void setUp(float stepSizeX, float stepSizeY, float pageSizeX, float pageSizeY, @Nonnull ScrollPanel.AutoScroll auto) {
        this.stepSizeX = stepSizeX;
        this.stepSizeY = stepSizeY;
        this.pageSizeX = pageSizeX;
        this.pageSizeY = pageSizeY;
        this.autoScroll = auto;
        this.initializeScrollbars();
    }

    @Override
    public void setAutoScroll(@Nonnull ScrollPanel.AutoScroll auto) {
        this.autoScroll = auto;
        this.updateWorldH();
        this.updateWorldV();
    }

    @Override
    @Nonnull
    public ScrollPanel.AutoScroll getAutoScroll() {
        return this.autoScroll;
    }

    @Override
    public void setStepSizeX(float stepSizeX) {
        this.stepSizeX = stepSizeX;
        Scrollbar horizontalS = this.getHorizontalScrollbarControl();
        if (horizontalS != null) {
            horizontalS.setButtonStepSize(stepSizeX);
        }
    }

    @Override
    public void setStepSizeY(float stepSizeY) {
        this.stepSizeY = stepSizeY;
        Scrollbar verticalS = this.getHorizontalScrollbarControl();
        if (verticalS != null) {
            verticalS.setButtonStepSize(stepSizeY);
        }
    }

    @Override
    public void setPageSizeX(float pageSizeX) {
        this.pageSizeX = pageSizeX;
        Scrollbar horizontalS = this.getHorizontalScrollbarControl();
        if (horizontalS != null) {
            horizontalS.setPageStepSize(pageSizeX);
        }
    }

    @Override
    public void setPageSizeY(float pageSizeY) {
        this.pageSizeY = pageSizeY;
        Scrollbar verticalS = this.getVerticalScrollbarControl();
        if (verticalS != null) {
            verticalS.setPageStepSize(pageSizeY);
        }
    }

    public void mouseWheel(Element e, @Nonnull NiftyMouseInputEvent inputEvent) {
        int mouseWheel = inputEvent.getMouseWheel();
        Scrollbar verticalS = this.getVerticalScrollbarControl();
        if (verticalS != null) {
            float currentValue = verticalS.getValue();
            if (mouseWheel < 0) {
                verticalS.setValue(currentValue - verticalS.getButtonStepSize() * (float)mouseWheel);
            } else if (mouseWheel > 0) {
                verticalS.setValue(currentValue - verticalS.getButtonStepSize() * (float)mouseWheel);
            }
        }
    }

    @Nullable
    private Element getChildById(@Nonnull String id) {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return element.findElementById(id);
    }

    @Nullable
    private Element getVerticalScrollbar() {
        if (this.verticalScrollbar) {
            return this.getChildById("#nifty-internal-vertical-scrollbar");
        }
        return null;
    }

    @Nullable
    private Scrollbar getVerticalScrollbarControl() {
        Element element = this.getVerticalScrollbar();
        if (element == null) {
            return null;
        }
        return (Scrollbar)element.getNiftyControl(Scrollbar.class);
    }

    @Nullable
    private Element getHorizontalScrollbar() {
        if (this.horizontalScrollbar) {
            return this.getChildById("#nifty-internal-horizontal-scrollbar");
        }
        return null;
    }

    @Nullable
    private Scrollbar getHorizontalScrollbarControl() {
        Element element = this.getHorizontalScrollbar();
        if (element == null) {
            return null;
        }
        return (Scrollbar)element.getNiftyControl(Scrollbar.class);
    }

    private void initializeScrollPanel(@Nonnull Nifty nifty, @Nonnull Screen screen) {
        Element horizontal;
        Element vertical;
        if (!this.verticalScrollbar && (vertical = this.getChildById("#nifty-internal-vertical-scrollbar")) != null) {
            nifty.removeElement(screen, vertical);
        }
        if (!this.horizontalScrollbar && (horizontal = this.getChildById("#nifty-internal-horizontal-panel")) != null) {
            nifty.removeElement(screen, horizontal);
        }
    }

    private void initializeScrollbars() {
        if (this.childRootElement != null) {
            List elements = this.childRootElement.getChildren();
            if (elements.isEmpty()) {
                return;
            }
            Element scrollElement = (Element)elements.get(0);
            if (scrollElement != null) {
                Scrollbar verticalS;
                Scrollbar horizontalS = this.getHorizontalScrollbarControl();
                if (horizontalS != null) {
                    horizontalS.setWorldMax(scrollElement.getWidth());
                    this.updateWorldH();
                    horizontalS.setWorldPageSize(horizontalS.getWidth());
                    horizontalS.setValue(0.0f);
                    horizontalS.setButtonStepSize(this.stepSizeX);
                    horizontalS.setPageStepSize(this.pageSizeX);
                }
                if ((verticalS = this.getVerticalScrollbarControl()) != null) {
                    verticalS.setWorldMax(scrollElement.getHeight());
                    this.updateWorldV();
                    verticalS.setWorldPageSize(verticalS.getHeight());
                    verticalS.setValue(0.0f);
                    verticalS.setButtonStepSize(this.stepSizeY);
                    verticalS.setPageStepSize(this.pageSizeY);
                }
                scrollElement.setConstraintX(SizeValue.px((int)0));
                scrollElement.setConstraintY(SizeValue.px((int)0));
                this.childRootElement.layoutElements();
            }
        }
    }

    private void updateWorldH() {
        Scrollbar horizontalS = this.getHorizontalScrollbarControl();
        if (horizontalS != null) {
            if (this.autoScroll == ScrollPanel.AutoScroll.RIGHT || this.autoScroll == ScrollPanel.AutoScroll.BOTTOM_RIGHT || this.autoScroll == ScrollPanel.AutoScroll.TOP_RIGHT) {
                horizontalS.setValue(horizontalS.getWorldMax());
            } else if (this.autoScroll == ScrollPanel.AutoScroll.LEFT || this.autoScroll == ScrollPanel.AutoScroll.BOTTOM_LEFT || this.autoScroll == ScrollPanel.AutoScroll.TOP_LEFT) {
                horizontalS.setValue(0.0f);
            }
        }
    }

    private void updateWorldV() {
        Scrollbar verticalS = this.getVerticalScrollbarControl();
        if (verticalS != null) {
            if (this.autoScroll == ScrollPanel.AutoScroll.BOTTOM || this.autoScroll == ScrollPanel.AutoScroll.BOTTOM_LEFT || this.autoScroll == ScrollPanel.AutoScroll.BOTTOM_RIGHT) {
                verticalS.setValue(verticalS.getWorldMax());
            } else if (this.autoScroll == ScrollPanel.AutoScroll.TOP || this.autoScroll == ScrollPanel.AutoScroll.TOP_LEFT || this.autoScroll == ScrollPanel.AutoScroll.TOP_RIGHT) {
                verticalS.setValue(0.0f);
            }
        }
    }

    private void showElementVertical(int elemCount, @Nonnull ScrollPanel.VerticalAlign valign) {
        float newPos;
        switch (valign) {
            case top: {
                newPos = this.stepSizeY * (float)elemCount;
                break;
            }
            case center: {
                newPos = this.stepSizeY * (float)elemCount - (float)(this.getHeight() / 2);
                break;
            }
            case bottom: {
                newPos = this.stepSizeY * (float)elemCount - (float)this.getHeight();
                break;
            }
            default: {
                newPos = 0.0f;
            }
        }
        this.setVerticalPos(newPos);
    }

    private class HorizontalEventTopicSubscriber
    implements EventTopicSubscriber<ScrollbarChangedEvent> {
        @Nonnull
        private final ScrollPanel scrollPanel;

        public HorizontalEventTopicSubscriber(ScrollPanel scrollPanel) {
            this.scrollPanel = scrollPanel;
        }

        public void onEvent(String id, @Nonnull ScrollbarChangedEvent event) {
            if (ScrollPanelControl.this.childRootElement == null) {
                return;
            }
            if (ScrollPanelControl.this.childRootElement.getChildren().isEmpty()) {
                return;
            }
            Element scrollElement = (Element)ScrollPanelControl.this.childRootElement.getChildren().get(0);
            if (scrollElement != null) {
                String panelId;
                scrollElement.setConstraintX(SizeValue.px((int)(-((int)event.getValue()))));
                ScrollPanelControl.this.updateWorldH();
                ScrollPanelControl.this.childRootElement.layoutElements();
                float yPos = 0.0f;
                Scrollbar verticalS = ScrollPanelControl.this.getVerticalScrollbarControl();
                if (verticalS != null && ScrollPanelControl.this.verticalScrollbar) {
                    yPos = verticalS.getValue();
                }
                if (ScrollPanelControl.this.nifty != null && (panelId = ScrollPanelControl.this.getId()) != null) {
                    ScrollPanelControl.this.nifty.publishEvent(panelId, (NiftyEvent)new ScrollPanelChangedEvent(this.scrollPanel, event.getValue(), yPos));
                }
            }
        }
    }

    private class VerticalEventTopicSubscriber
    implements EventTopicSubscriber<ScrollbarChangedEvent> {
        @Nonnull
        private final ScrollPanel scrollPanel;

        public VerticalEventTopicSubscriber(ScrollPanel scrollPanel) {
            this.scrollPanel = scrollPanel;
        }

        public void onEvent(String id, @Nonnull ScrollbarChangedEvent event) {
            if (ScrollPanelControl.this.childRootElement == null) {
                return;
            }
            if (ScrollPanelControl.this.childRootElement.getChildren().isEmpty()) {
                return;
            }
            Element scrollElement = (Element)ScrollPanelControl.this.childRootElement.getChildren().get(0);
            if (scrollElement != null) {
                String panelId;
                scrollElement.setConstraintY(SizeValue.px((int)(-((int)event.getValue()))));
                ScrollPanelControl.this.updateWorldV();
                ScrollPanelControl.this.childRootElement.layoutElements();
                float xPos = 0.0f;
                Scrollbar horizontalS = ScrollPanelControl.this.getHorizontalScrollbarControl();
                if (horizontalS != null && ScrollPanelControl.this.horizontalScrollbar) {
                    xPos = horizontalS.getValue();
                }
                if (ScrollPanelControl.this.nifty != null && (panelId = ScrollPanelControl.this.getId()) != null) {
                    ScrollPanelControl.this.nifty.publishEvent(panelId, (NiftyEvent)new ScrollPanelChangedEvent(this.scrollPanel, xPos, event.getValue()));
                }
            }
        }
    }
}

