/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.checkbox;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.CheckBox;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.checkbox.CheckBoxImpl;
import de.lessvoid.nifty.controls.checkbox.CheckBoxView;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.ElementShowEvent;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class CheckboxControl
extends AbstractController
implements CheckBox,
CheckBoxView,
EventTopicSubscriber<ElementShowEvent> {
    @Nonnull
    private static final Logger log = Logger.getLogger(CheckboxControl.class.getName());
    @Nonnull
    private final CheckBoxImpl checkBoxImpl = new CheckBoxImpl(this);
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    @Nullable
    private FocusHandler focusHandler;

    public void bind(@Nonnull Nifty niftyParam, @Nonnull Screen screenParam, @Nonnull Element elementParam, @Nonnull Parameters propertiesParam) {
        super.bind(elementParam);
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.checkBoxImpl.bindToView(this);
        this.checkBoxImpl.setInitialCheckedState(propertiesParam.getAsBoolean("checked", false));
    }

    public void init(@Nonnull Parameters parameter) {
        String id;
        super.init(parameter);
        if (this.screen == null || this.nifty == null) {
            log.severe("Required instances not found, binding did not run or failed.");
        }
        if ((id = this.getId()) == null) {
            log.warning("Checkbox has not ID, can't register a event subscriber to monitor update events. Checkbox functionality will be limited.");
        } else {
            this.focusHandler = this.screen.getFocusHandler();
            this.nifty.subscribe(this.screen, id, ElementShowEvent.class, (EventTopicSubscriber)this);
        }
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyStandardInputEvent.Activate) {
            this.onClick();
            return true;
        }
        if (this.focusHandler == null) {
            return false;
        }
        Element element = this.getElement();
        if (element == null) {
            return false;
        }
        if (inputEvent == NiftyStandardInputEvent.NextInputElement) {
            this.focusHandler.getNext(element).setFocus();
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.PrevInputElement) {
            this.focusHandler.getPrev(element).setFocus();
            return true;
        }
        return false;
    }

    public boolean onClick() {
        this.checkBoxImpl.toggle();
        return true;
    }

    @Override
    public void update(boolean checked) {
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        Element selectImage = this.getElement().findElementById("#select");
        if (selectImage == null) {
            log.warning("Failed to find select image of checkbox. Can't display select state.");
            return;
        }
        if (checked) {
            selectImage.setVisible(true);
        } else {
            selectImage.setVisible(false);
        }
    }

    @Override
    public void publish(@Nonnull CheckBoxStateChangedEvent event) {
        String id;
        if (this.nifty != null && (id = this.getId()) != null) {
            this.nifty.publishEvent(id, (NiftyEvent)event);
        }
    }

    public void onEvent(String topic, ElementShowEvent data) {
        Element selectImage;
        Element element = this.getElement();
        if (element != null && (selectImage = element.findElementById("#select")) != null) {
            selectImage.setVisible(this.checkBoxImpl.isChecked());
        }
    }

    @Override
    public void check() {
        this.checkBoxImpl.check();
    }

    @Override
    public void uncheck() {
        this.checkBoxImpl.uncheck();
    }

    @Override
    public void setChecked(boolean state) {
        this.checkBoxImpl.setChecked(state);
    }

    @Override
    public boolean isChecked() {
        return this.checkBoxImpl.isChecked();
    }

    @Override
    public void toggle() {
        this.checkBoxImpl.toggle();
    }
}

