/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.checkbox;

import de.lessvoid.nifty.controls.CheckBox;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.controls.checkbox.CheckBoxView;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class CheckBoxImpl {
    private static final Logger log = Logger.getLogger(CheckBoxImpl.class.getName());
    @Nonnull
    private final CheckBox checkbox;
    private boolean checked;
    @Nullable
    private CheckBoxView view;

    public CheckBoxImpl(@Nonnull CheckBox checkbox) {
        this.checkbox = checkbox;
    }

    public void bindToView(@Nonnull CheckBoxView checkBoxView) {
        this.view = checkBoxView;
    }

    public void check() {
        this.internalSetChecked(true);
    }

    public void uncheck() {
        this.internalSetChecked(false);
    }

    public void setChecked(boolean state) {
        this.internalSetChecked(state);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    private void internalSetChecked(boolean newState) {
        if (this.checked == newState) {
            return;
        }
        this.changeChecked(newState);
    }

    private void changeChecked(boolean newState) {
        this.checked = newState;
        this.updateView();
    }

    void setInitialCheckedState(boolean checked) {
        this.changeChecked(checked);
    }

    private void updateView() {
        if (this.view == null) {
            log.warning("Updating view is not possible before the view is bound. The bind call is likely missing.");
        } else {
            this.view.update(this.checked);
            this.view.publish(new CheckBoxStateChangedEvent(this.checkbox, this.checked));
        }
    }
}

