/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TreeItem<T>
implements Iterable<TreeItem<T>> {
    @Nonnull
    private final List<TreeItem<T>> children = new ArrayList<TreeItem<T>>();
    @Nullable
    private TreeItem<T> parentItem;
    private boolean expanded;
    @Nullable
    private T value;
    private int indent;

    public TreeItem() {
    }

    public TreeItem(@Nullable T itemValue) {
        this();
        this.value = itemValue;
    }

    public void addTreeItem(TreeItem<T> item) {
        this.children.add(item);
        item.setParentItem(this);
    }

    public void addTreeItems(@Nonnull Collection<TreeItem<T>> items) {
        for (TreeItem<T> t : items) {
            this.addTreeItem(t);
        }
    }

    public void removeTreeItem(TreeItem<T> item) {
        this.children.remove(item);
        item.setParentItem(null);
    }

    public void removeTreeItems(@Nonnull Collection<TreeItem<T>> items) {
        for (TreeItem<T> t : items) {
            this.removeTreeItem(t);
        }
    }

    @Override
    @Nonnull
    public Iterator<TreeItem<T>> iterator() {
        return this.children.iterator();
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    public void setValue(@Nullable T value) {
        this.value = value;
    }

    @Nullable
    public TreeItem<T> getParentItem() {
        return this.parentItem;
    }

    public void setParentItem(@Nullable TreeItem<T> parentItem) {
        this.parentItem = parentItem;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }
}

