/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.controls.Scrollbar;
import de.lessvoid.nifty.controls.listbox.ListBoxItemProcessor;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.spi.render.RenderFont;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ListBox<T>
extends NiftyControl {
    public void changeSelectionMode(@Nonnull SelectionMode var1, boolean var2);

    public void setListBoxViewConverter(@Nonnull ListBoxViewConverter<T> var1);

    public void addItem(@Nonnull T var1);

    public void insertItem(@Nonnull T var1, int var2);

    public int itemCount();

    public void clear();

    public void selectItemByIndex(int var1);

    public void selectItem(@Nonnull T var1);

    public void selectNext();

    public void selectPrevious();

    public void deselectItemByIndex(int var1);

    public void deselectItem(@Nonnull T var1);

    @Nonnull
    public List<T> getSelection();

    @Nonnull
    public List<Integer> getSelectedIndices();

    public void removeItemByIndex(int var1);

    public void removeItem(@Nonnull T var1);

    @Nonnull
    public List<T> getItems();

    public void showItem(@Nonnull T var1);

    public void showItemByIndex(int var1);

    public void setFocusItem(@Nullable T var1);

    public void setFocusItemByIndex(int var1);

    @Nullable
    public T getFocusItem();

    public int getFocusItemIndex();

    public void addAllItems(@Nonnull Collection<T> var1);

    public void removeAllItems(@Nonnull Collection<T> var1);

    public void sortAllItems();

    public int getDisplayItemCount();

    public void sortAllItems(@Nullable Comparator<T> var1);

    public void refresh();

    public void addItemProcessor(@Nonnull ListBoxItemProcessor var1);

    public Scrollbar getHorizontalScrollbar();

    public Scrollbar getVerticalScrollbar();

    public static class ListBoxViewConverterSimple<T>
    implements ListBoxViewConverter<T> {
        private final Logger log = Logger.getLogger(ListBoxViewConverterSimple.class.getName());

        @Override
        public void display(@Nonnull Element element, @Nonnull T item) {
            TextRenderer renderer = (TextRenderer)element.getRenderer(TextRenderer.class);
            if (renderer == null) {
                this.log.warning("you're using the ListBoxViewConverterSimple but there is no TextRenderer on the listBoxElement.You've probably changed the item template but did not provided your own ListBoxViewConverter to the ListBox.");
                return;
            }
            renderer.setText(item.toString());
        }

        @Override
        public int getWidth(@Nonnull Element element, @Nonnull T item) {
            TextRenderer renderer = (TextRenderer)element.getRenderer(TextRenderer.class);
            if (renderer == null) {
                this.log.warning("you're using the ListBoxViewConverterSimple but there is no TextRenderer on the listBoxElement.You've probably changed the item template but did not provided your own ListBoxViewConverter to the ListBox.");
                return 0;
            }
            RenderFont font = renderer.getFont();
            if (font != null) {
                String resultText = element.getNifty().specialValuesReplace(item.toString());
                return font.getWidth(resultText);
            }
            return 0;
        }
    }

    public static interface ListBoxViewConverter<T> {
        public void display(@Nonnull Element var1, @Nonnull T var2);

        public int getWidth(@Nonnull Element var1, @Nonnull T var2);
    }

    public static enum SelectionMode {
        Single,
        Multiple,
        Disabled;

    }
}

