/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.spi.render.RenderFont;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface DropDown<T>
extends NiftyControl {
    public void setViewConverter(@Nonnull DropDownViewConverter<T> var1);

    public void addItem(@Nonnull T var1);

    public void insertItem(@Nonnull T var1, int var2);

    public int itemCount();

    public void clear();

    public void selectItemByIndex(int var1);

    public void selectItem(@Nonnull T var1);

    @Nullable
    public T getSelection();

    public int getSelectedIndex();

    public void removeItemByIndex(int var1);

    public void removeItem(T var1);

    @Nonnull
    public List<T> getItems();

    public void addAllItems(@Nonnull Collection<T> var1);

    public void removeAllItems(@Nonnull Collection<T> var1);

    public static class SimpleDropDownViewConverter<T>
    implements DropDownViewConverter<T> {
        private final Logger log = Logger.getLogger(SimpleDropDownViewConverter.class.getName());

        @Override
        public void display(@Nonnull Element element, @Nullable T item) {
            TextRenderer renderer = (TextRenderer)element.getRenderer(TextRenderer.class);
            if (renderer == null) {
                this.log.warning("you're using the SimpleDropDownViewConverter but there is no TextRenderer on the element.You've probably changed the item template but did not provided your own DropDownViewConverter to the DropDown.");
                return;
            }
            if (item != null) {
                renderer.setText(item.toString());
            } else {
                renderer.setText("");
            }
        }

        @Override
        public int getWidth(@Nonnull Element element, @Nonnull T item) {
            TextRenderer renderer = (TextRenderer)element.getRenderer(TextRenderer.class);
            if (renderer == null) {
                this.log.warning("you're using the SimpleDropDownViewConverter but there is no TextRenderer on the element.You've probably changed the item template but did not provided your own DropDownViewConverter to the DropDown.");
                return 0;
            }
            RenderFont font = renderer.getFont();
            if (font == null) {
                return 0;
            }
            return font.getWidth(item.toString());
        }
    }

    public static interface DropDownViewConverter<T> {
        public void display(@Nonnull Element var1, @Nonnull T var2);

        public int getWidth(@Nonnull Element var1, @Nonnull T var2);
    }
}

