/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.domain;

import java.time.Duration;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class RetentionPolicy {
    private final String name;
    private final Duration duration;
    private final int replication;
    private final Duration shardDuration;
    private boolean isDefault;

    private RetentionPolicy(Builder builder) {
        this.name = builder.name;
        this.duration = builder.duration;
        this.replication = builder.replication;
        this.shardDuration = builder.shardDuration;
        this.isDefault = builder.isDefault;
        if (StringUtils.isBlank((CharSequence)this.name)) {
            throw new IllegalStateException("Retention policy name cannot be blank");
        }
        if (this.duration == null || this.duration.isNegative()) {
            throw new IllegalStateException("Duration cannot be null or negative");
        }
        if (this.replication < 1) {
            throw new IllegalStateException("Replication cannot be negative");
        }
        if (this.shardDuration == null || this.shardDuration.isNegative()) {
            throw new IllegalStateException("Shard duration cannot be null or negative");
        }
    }

    public String getName() {
        return this.name;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public RetentionPolicy withDuration(Duration duration) {
        return new Builder(this).duration(duration).build();
    }

    public int getReplication() {
        return this.replication;
    }

    public RetentionPolicy withReplication(int replication) {
        return new Builder(this).replication(replication).build();
    }

    public Duration getShardDuration() {
        return this.shardDuration;
    }

    public RetentionPolicy withShardDuration(Duration shardDuration) {
        return new Builder(this).shardDuration(shardDuration).build();
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public RetentionPolicy asDefault(boolean isDefault) {
        return new Builder(this).isDefault(isDefault).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetentionPolicy that = (RetentionPolicy)o;
        return this.replication == that.replication && this.isDefault == that.isDefault && this.name.equals(that.name) && this.duration.equals(that.duration) && Objects.equals(this.shardDuration, that.shardDuration);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.duration, this.replication, this.shardDuration, this.isDefault);
    }

    public String toString() {
        return "RetentionPolicy{name='" + this.name + '\'' + ", duration=" + this.duration + ", replication=" + this.replication + ", shardDuration=" + this.shardDuration + ", isDefault=" + this.isDefault + '}';
    }

    public static final class Builder {
        private String name;
        private Duration duration;
        private int replication;
        private Duration shardDuration;
        private boolean isDefault;

        public Builder(String name, Duration duration) {
            this.name = name;
            this.duration = duration;
            this.replication = 1;
            this.shardDuration = Duration.ZERO;
            this.isDefault = false;
        }

        private Builder(RetentionPolicy retentionPolicy) {
            this.name = retentionPolicy.name;
            this.duration = retentionPolicy.duration;
            this.replication = retentionPolicy.replication;
            this.shardDuration = retentionPolicy.shardDuration;
            this.isDefault = retentionPolicy.isDefault;
        }

        public Builder duration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public Builder replication(int replication) {
            this.replication = replication;
            return this;
        }

        public Builder shardDuration(Duration shardDuration) {
            this.shardDuration = shardDuration;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public RetentionPolicy build() {
            return new RetentionPolicy(this);
        }
    }
}

