/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.domain;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Point {
    private final Instant timestamp;
    private final Map<String, String> tags;
    private final Map<String, Object> fields;

    private Point(Builder builder) {
        this.timestamp = builder.timestamp;
        this.tags = builder.tags;
        this.fields = builder.fields;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getTags() {
        return new HashMap<String, String>(this.tags);
    }

    public Map<String, Object> getFields() {
        return new HashMap<String, Object>(this.fields);
    }

    public String toString() {
        return "Point{timestamp=" + this.timestamp + ", tags=" + this.tags + ", fields=" + this.fields + '}';
    }

    public static final class Builder {
        private Instant timestamp;
        private Map<String, String> tags = Collections.emptyMap();
        private Map<String, Object> fields = Collections.emptyMap();

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder fields(Map<String, Object> fields) {
            this.fields = fields;
            return this;
        }

        public Point build() {
            return new Point(this);
        }
    }
}

