/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.domain;

import com.github.nickrm.jflux.domain.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Measurement {
    private final String name;
    private final List<Point> points;

    private Measurement(Builder builder) {
        this.name = builder.name;
        this.points = builder.points;
    }

    public String getName() {
        return this.name;
    }

    public List<Point> getPoints() {
        return new ArrayList<Point>(this.points);
    }

    public String toString() {
        return "Measurement{name='" + this.name + '\'' + ", points=" + this.points + '}';
    }

    public static final class Builder {
        private String name;
        private List<Point> points = Collections.emptyList();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder points(List<Point> points) {
            this.points = points;
            return this;
        }

        public Measurement build() {
            return new Measurement(this);
        }
    }
}

