/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.api.response;

import com.github.nickrm.jflux.domain.Measurement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class QueryResult {
    private final int statementId;
    private final String error;
    private final List<Measurement> results;

    private QueryResult(Builder builder) {
        this.statementId = builder.statementId;
        this.error = builder.error;
        this.results = builder.results;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public String getError() {
        return this.error;
    }

    public List<Measurement> getResults() {
        return new ArrayList<Measurement>(this.results);
    }

    public String toString() {
        return "QueryResult{statementId=" + this.statementId + ", error='" + this.error + '\'' + ", results=" + this.results + '}';
    }

    public static final class Builder {
        private int statementId;
        private String error;
        private List<Measurement> results = Collections.emptyList();

        public Builder statementId(int statementId) {
            this.statementId = statementId;
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            return this;
        }

        public Builder series(List<Measurement> results) {
            this.results = results;
            return this;
        }

        public QueryResult build() {
            return new QueryResult(this);
        }
    }
}

