/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.api.response;

import com.github.nickrm.jflux.api.response.QueryResult;
import com.github.nickrm.jflux.api.response.ResponseMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ApiResponse {
    private final ResponseMetadata metadata;
    private final int statusCode;
    private final String errorMessage;
    private final List<QueryResult> results;

    private ApiResponse(Builder builder) {
        this.metadata = builder.metadata;
        this.statusCode = builder.statusCode;
        this.errorMessage = builder.errorMessage;
        this.results = builder.results;
    }

    public ResponseMetadata getMetadata() {
        return this.metadata;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean hasError() {
        return this.getErrorMessage() != null;
    }

    public String getErrorMessage() {
        return this.errorMessage != null ? this.errorMessage : (String)this.results.stream().map(QueryResult::getError).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public List<QueryResult> getResults() {
        return new ArrayList<QueryResult>(this.results);
    }

    public String toString() {
        return "ApiResponse{, statusCode=" + this.statusCode + ", errorMessage='" + this.errorMessage + '\'' + ", results=" + this.results + '}';
    }

    public static final class Builder {
        private ResponseMetadata metadata;
        private int statusCode;
        private String errorMessage;
        private List<QueryResult> results = Collections.emptyList();

        public Builder metadata(ResponseMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder results(List<QueryResult> results) {
            this.results = results;
            return this;
        }

        public ApiResponse build() {
            return new ApiResponse(this);
        }
    }
}

