/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.api.converter;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.nickrm.jflux.api.response.QueryResult;
import com.github.nickrm.jflux.domain.Measurement;
import com.github.nickrm.jflux.domain.Point;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;

final class ResponseBodyConverter
implements Converter<ResponseBody, List<QueryResult>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseBodyConverter.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    ResponseBodyConverter() {
    }

    public List<QueryResult> convert(ResponseBody responseBody) throws IOException {
        String content = responseBody.string();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        LOGGER.debug("Converting response body: {}", (Object)content);
        ResponseDto responseDto = (ResponseDto)this.objectMapper.readValue(content, ResponseDto.class);
        return this.responseFromDto(responseDto);
    }

    private List<QueryResult> responseFromDto(ResponseDto responseDto) {
        LinkedList<QueryResult> results = new LinkedList<QueryResult>();
        if (responseDto.results != null) {
            for (ResultDto resultDto : responseDto.results) {
                results.add(this.resultFromDto(resultDto));
            }
        }
        return results;
    }

    private QueryResult resultFromDto(ResultDto resultDto) {
        LinkedList<Measurement> measurements = new LinkedList<Measurement>();
        if (resultDto.series != null) {
            for (SeriesDto seriesDto : resultDto.series) {
                measurements.add(this.seriesFromDto(seriesDto));
            }
        }
        return new QueryResult.Builder().statementId(resultDto.statementId).error(resultDto.error).series(measurements).build();
    }

    private Measurement seriesFromDto(SeriesDto seriesDto) {
        List<Point> points = this.pointsFromSeriesDto(seriesDto);
        return new Measurement.Builder().name(seriesDto.name).points(points).build();
    }

    private List<Point> pointsFromSeriesDto(SeriesDto seriesDto) {
        LinkedList<Point> points = new LinkedList<Point>();
        if (seriesDto.columns != null && seriesDto.values != null) {
            for (Object[] row : seriesDto.values) {
                Point point = this.pointFromRow(seriesDto.columns, row);
                points.add(point);
            }
        }
        return points;
    }

    private Point pointFromRow(String[] columns, Object[] row) {
        Instant timestamp = null;
        int startIndex = 0;
        if (columns[0].equals("time")) {
            timestamp = Instant.parse(row[0].toString());
            startIndex = 1;
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = startIndex; i < columns.length; ++i) {
            String columnName = columns[i];
            Object value = row[i];
            if (value instanceof Number || value instanceof Boolean) {
                fields.put(columnName, value);
                continue;
            }
            tags.put(columnName, String.valueOf(value));
        }
        return new Point.Builder().timestamp(timestamp).tags(tags).fields(fields).build();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static final class SeriesDto {
        @JsonProperty
        private String name;
        @JsonProperty
        private String[] columns;
        @JsonProperty
        private Object[][] values;

        private SeriesDto() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static final class ResultDto {
        @JsonProperty(value="statement_id")
        private int statementId;
        @JsonProperty
        private String error;
        @JsonProperty
        private SeriesDto[] series;

        private ResultDto() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static final class ResponseDto {
        @JsonProperty
        private ResultDto[] results;

        private ResponseDto() {
        }
    }
}

