/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.api.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Response;

final class ErrorResponseConverter
implements Converter<Response<?>, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorResponseConverter.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    ErrorResponseConverter() {
    }

    public String convert(Response<?> response) throws IOException {
        if (response.errorBody() != null) {
            return this.getErrorMessageFromErrorBody(response.errorBody());
        }
        return null;
    }

    private String getErrorMessageFromErrorBody(ResponseBody errorBody) throws IOException {
        String content = errorBody.string();
        if (content != null && content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        LOGGER.debug("Converting {}", (Object)content);
        String errorMessage = this.objectMapper.readTree(content).get("error").toString();
        if (errorMessage.startsWith("\"")) {
            errorMessage = errorMessage.substring(1);
        }
        if (errorMessage.endsWith("\"")) {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 1);
        }
        return errorMessage;
    }
}

