/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux;

import com.github.nickrm.jflux.ApiCaller;
import com.github.nickrm.jflux.DurationConverter;
import com.github.nickrm.jflux.RetentionPolicyConverter;
import com.github.nickrm.jflux.api.JFluxHttpClient;
import com.github.nickrm.jflux.domain.Measurement;
import com.github.nickrm.jflux.domain.RetentionPolicy;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RetentionPolicyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetentionPolicyManager.class);
    private final JFluxHttpClient httpClient;
    private final ApiCaller apiCaller;

    RetentionPolicyManager(JFluxHttpClient httpClient) {
        this.httpClient = httpClient;
        this.apiCaller = new ApiCaller();
    }

    List<RetentionPolicy> getRetentionPolicies(String databaseName) {
        if (databaseName == null) {
            throw new IllegalArgumentException("Database name cannot be null");
        }
        String query = "SHOW RETENTION POLICIES ON \"" + databaseName + "\"";
        Measurement queryResult = this.apiCaller.callApi(() -> this.httpClient.query(query));
        RetentionPolicyConverter converter = new RetentionPolicyConverter();
        List<RetentionPolicy> retentionPolicies = queryResult.getPoints().stream().map(converter::parsePoint).collect(Collectors.toList());
        LOGGER.debug("Found retention policies {} on '{}'", retentionPolicies, (Object)databaseName);
        return retentionPolicies;
    }

    RetentionPolicy getRetentionPolicy(String retentionPolicyName, String databaseName) {
        if (retentionPolicyName == null) {
            throw new IllegalArgumentException("Retention policy cannot be null");
        }
        return this.getRetentionPolicies(databaseName).stream().filter(rp -> rp.getName().equals(retentionPolicyName)).findFirst().orElse(null);
    }

    boolean retentionPolicyExists(String retentionPolicyName, String databaseName) {
        return this.getRetentionPolicy(retentionPolicyName, databaseName) != null;
    }

    void createRetentionPolicy(RetentionPolicy retentionPolicy, String databaseName) {
        if (retentionPolicy == null) {
            throw new IllegalArgumentException("Retention policy cannot be null");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Database name cannot be null");
        }
        DurationConverter durationConverter = new DurationConverter();
        String statement = "CREATE RETENTION POLICY \"" + retentionPolicy.getName() + '\"' + " ON \"" + databaseName + '\"' + " DURATION " + durationConverter.toLiteral(retentionPolicy.getDuration()) + " REPLICATION " + retentionPolicy.getReplication() + " SHARD DURATION " + durationConverter.toLiteral(retentionPolicy.getShardDuration()) + (retentionPolicy.isDefault() ? " DEFAULT" : "");
        this.apiCaller.callApi(() -> this.httpClient.execute(statement));
        LOGGER.info("Created retention policy {} on '{}'", (Object)retentionPolicy, (Object)databaseName);
    }

    void alterRetentionPolicy(String retentionPolicyName, String databaseName, RetentionPolicy newDefinition) {
        if (retentionPolicyName == null) {
            throw new IllegalArgumentException("Retention policy name cannot be null");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Database name cannot be null");
        }
        if (newDefinition == null) {
            throw new IllegalArgumentException("Retention policy definition cannot be null");
        }
        if (!retentionPolicyName.equals(newDefinition.getName())) {
            LOGGER.warn("Retention policy name cannot be altered, will remain '{}'", (Object)retentionPolicyName);
        }
        DurationConverter durationConverter = new DurationConverter();
        String statement = "ALTER RETENTION POLICY \"" + retentionPolicyName + '\"' + " ON \"" + databaseName + '\"' + " DURATION " + durationConverter.toLiteral(newDefinition.getDuration()) + " REPLICATION " + newDefinition.getReplication() + " SHARD DURATION " + durationConverter.toLiteral(newDefinition.getShardDuration()) + (newDefinition.isDefault() ? " DEFAULT" : "");
        this.apiCaller.callApi(() -> this.httpClient.execute(statement));
        LOGGER.info("Updated '{}'.'{}' to {}", new Object[]{databaseName, retentionPolicyName, newDefinition});
    }

    void dropRetentionPolicy(String retentionPolicyName, String databaseName) {
        if (retentionPolicyName == null) {
            throw new IllegalArgumentException("Retention policy name cannot be null");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Database name cannot be null");
        }
        String statement = "DROP RETENTION POLICY \"" + retentionPolicyName + "\" ON \"" + databaseName + '\"';
        this.apiCaller.callApi(() -> this.httpClient.execute(statement));
        LOGGER.info("Dropped retention policy '{}' on '{}'", (Object)retentionPolicyName, (Object)databaseName);
    }
}

