/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux;

import com.github.nickrm.jflux.annotation.Field;
import com.github.nickrm.jflux.annotation.Measurement;
import com.github.nickrm.jflux.annotation.Tag;

final class NamingStrategy {
    NamingStrategy() {
    }

    String getMeasurementName(Class<?> measurementClass) {
        if (measurementClass == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (measurementClass.isAnnotationPresent(Measurement.class) && !measurementClass.getAnnotation(Measurement.class).value().isEmpty()) {
            return measurementClass.getAnnotation(Measurement.class).value();
        }
        return this.toSnakeCase(measurementClass.getSimpleName());
    }

    String getFieldName(java.lang.reflect.Field instanceField) {
        if (instanceField == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        if (instanceField.isAnnotationPresent(Field.class) && !instanceField.getAnnotation(Field.class).value().isEmpty()) {
            return instanceField.getAnnotation(Field.class).value();
        }
        return this.toSnakeCase(instanceField.getName());
    }

    String getTagName(java.lang.reflect.Field instanceField) {
        if (instanceField == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        if (instanceField.isAnnotationPresent(Tag.class) && !instanceField.getAnnotation(Tag.class).value().isEmpty()) {
            return instanceField.getAnnotation(Tag.class).value();
        }
        return this.toSnakeCase(instanceField.getName());
    }

    private String toSnakeCase(String value) {
        StringBuilder sb = new StringBuilder();
        char[] charArray = value.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (i > 0 && Character.isUpperCase(c)) {
                sb.append("_");
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }
}

