/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux;

import com.github.nickrm.jflux.ApiCaller;
import com.github.nickrm.jflux.api.JFluxHttpClient;
import com.github.nickrm.jflux.domain.Measurement;
import com.github.nickrm.jflux.domain.Point;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DatabaseManager {
    static final String INTERNAL_DATABASE_NAME = "_internal";
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseManager.class);
    private final JFluxHttpClient httpClient;
    private final ApiCaller apiCaller;

    DatabaseManager(JFluxHttpClient httpClient) {
        this.httpClient = httpClient;
        this.apiCaller = new ApiCaller();
    }

    List<String> getDatabases() {
        Measurement queryResult = this.apiCaller.callApi(() -> this.httpClient.query("SHOW DATABASES"));
        ArrayList<String> databases = new ArrayList<String>();
        for (Point point : queryResult.getPoints()) {
            databases.addAll(point.getTags().values());
        }
        LOGGER.debug("Found databases: {}", databases);
        return databases;
    }

    boolean databaseExists(String databaseName) {
        if (databaseName == null) {
            throw new IllegalArgumentException("Database name cannot be null");
        }
        return this.getDatabases().contains(databaseName);
    }

    void createDatabase(String databaseName) {
        if (databaseName == null) {
            throw new IllegalArgumentException("Database name cannot be null");
        }
        this.apiCaller.callApi(() -> this.httpClient.execute("CREATE DATABASE \"" + databaseName + "\""));
        LOGGER.info("Created database '{}'", (Object)databaseName);
    }

    void dropDatabase(String databaseName) {
        if (databaseName == null) {
            throw new IllegalArgumentException("Database cannot be null");
        }
        if (INTERNAL_DATABASE_NAME.equals(databaseName)) {
            throw new IllegalArgumentException("Cannot drop internal database");
        }
        this.apiCaller.callApi(() -> this.httpClient.execute("DROP DATABASE \"" + databaseName + "\""));
        LOGGER.info("Dropped database '{}'", (Object)databaseName);
    }
}

