/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux;

import java.io.IOException;

final class ApiCaller {
    ApiCaller() {
    }

    void callApi(IOThrowingRunnable apiMethod) {
        try {
            apiMethod.run();
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection to InfluxDB lost", e);
        }
    }

    <T> T callApi(IOThrowingSupplier<T> apiMethod) {
        try {
            return apiMethod.get();
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection to InfluxDB lost", e);
        }
    }

    static interface IOThrowingSupplier<T> {
        public T get() throws IOException;
    }

    static interface IOThrowingRunnable {
        public void run() throws IOException;
    }
}

