/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.widget.Toast;
import com.nguyenhoanglam.imagepicker.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005\u00a8\u0006\n"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/DeviceHelper;", "", "()V", "isMinSdk29", "", "()Z", "isMinSdk33", "checkCameraAvailability", "context", "Landroid/content/Context;", "imagepicker_release"})
public final class DeviceHelper {
    @NotNull
    public static final DeviceHelper INSTANCE = new DeviceHelper();

    private DeviceHelper() {
    }

    public final boolean isMinSdk29() {
        return Build.VERSION.SDK_INT >= 29;
    }

    public final boolean isMinSdk33() {
        return Build.VERSION.SDK_INT >= 33;
    }

    public final boolean checkCameraAvailability(@NotNull Context context) {
        boolean isAvailable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        boolean bl = isAvailable = intent.resolveActivity(context.getPackageManager()) != null;
        if (!isAvailable) {
            Context appContext = context.getApplicationContext();
            Toast.makeText((Context)appContext, (CharSequence)appContext.getString(R.string.imagepicker_error_no_camera), (int)1).show();
        }
        return isAvailable;
    }
}

