/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.widget;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/nguyenhoanglam/imagepicker/widget/ImagePickerToolbar;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backImage", "Landroidx/appcompat/widget/AppCompatImageView;", "cameraImage", "doneText", "Landroid/widget/TextView;", "titleText", "config", "", "Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;", "init", "setOnBackClickListener", "clickListener", "Landroid/view/View$OnClickListener;", "setOnCameraClickListener", "setOnDoneClickListener", "setTitle", "title", "", "showDoneButton", "isShow", "", "imagepicker_release"})
public final class ImagePickerToolbar
extends RelativeLayout {
    private TextView titleText;
    private TextView doneText;
    private AppCompatImageView backImage;
    private AppCompatImageView cameraImage;

    public ImagePickerToolbar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.init(context);
    }

    public ImagePickerToolbar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.init(context);
    }

    public ImagePickerToolbar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private final void init(Context context) {
        View.inflate((Context)context, (int)R.layout.imagepicker_toolbar, (ViewGroup)((ViewGroup)this));
        if (this.isInEditMode()) {
            return;
        }
        View view = this.findViewById(R.id.text_toolbar_title);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.text_toolbar_title)");
        this.titleText = (TextView)view;
        View view2 = this.findViewById(R.id.text_toolbar_done);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.text_toolbar_done)");
        this.doneText = (TextView)view2;
        View view3 = this.findViewById(R.id.image_toolbar_back);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.image_toolbar_back)");
        this.backImage = (AppCompatImageView)view3;
        View view4 = this.findViewById(R.id.image_toolbar_camera);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.image_toolbar_camera)");
        this.cameraImage = (AppCompatImageView)view4;
    }

    public final void config(@NotNull ImagePickerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.setBackgroundColor(Color.parseColor((String)config.getToolbarColor()));
        TextView textView = this.titleText;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleText");
            textView = null;
        }
        textView.setText(config.isFolderMode() ? (CharSequence)config.getFolderTitle() : (CharSequence)config.getImageTitle());
        TextView textView2 = this.titleText;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleText");
            textView2 = null;
        }
        textView2.setTextColor(Color.parseColor((String)config.getToolbarTextColor()));
        TextView textView3 = this.doneText;
        if (textView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"doneText");
            textView3 = null;
        }
        textView3.setText((CharSequence)config.getDoneTitle());
        TextView textView4 = this.doneText;
        if (textView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"doneText");
            textView4 = null;
        }
        textView4.setTextColor(Color.parseColor((String)config.getToolbarTextColor()));
        TextView textView5 = this.doneText;
        if (textView5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"doneText");
            textView5 = null;
        }
        textView5.setVisibility(config.isAlwaysShowDoneButton() ? 0 : 8);
        AppCompatImageView appCompatImageView = this.backImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backImage");
            appCompatImageView = null;
        }
        appCompatImageView.setColorFilter(Color.parseColor((String)config.getToolbarIconColor()));
        AppCompatImageView appCompatImageView2 = this.cameraImage;
        if (appCompatImageView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraImage");
            appCompatImageView2 = null;
        }
        appCompatImageView2.setColorFilter(Color.parseColor((String)config.getToolbarIconColor()));
        AppCompatImageView appCompatImageView3 = this.cameraImage;
        if (appCompatImageView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraImage");
            appCompatImageView3 = null;
        }
        appCompatImageView3.setVisibility(config.isShowCamera() ? 0 : 8);
    }

    public final void setTitle(@Nullable String title) {
        TextView textView = this.titleText;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleText");
            textView = null;
        }
        textView.setText((CharSequence)title);
    }

    public final void showDoneButton(boolean isShow) {
        TextView textView = this.doneText;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"doneText");
            textView = null;
        }
        textView.setVisibility(isShow ? 0 : 8);
    }

    public final void setOnBackClickListener(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        AppCompatImageView appCompatImageView = this.backImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backImage");
            appCompatImageView = null;
        }
        appCompatImageView.setOnClickListener(clickListener);
    }

    public final void setOnCameraClickListener(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        AppCompatImageView appCompatImageView = this.cameraImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraImage");
            appCompatImageView = null;
        }
        appCompatImageView.setOnClickListener(clickListener);
    }

    public final void setOnDoneClickListener(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        TextView textView = this.doneText;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"doneText");
            textView = null;
        }
        textView.setOnClickListener(clickListener);
    }
}

