/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.Window;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.databinding.ImagepickerActivityImagepickerBinding;
import com.nguyenhoanglam.imagepicker.helper.DeviceHelper;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.helper.PermissionHelper;
import com.nguyenhoanglam.imagepicker.helper.ToastHelper;
import com.nguyenhoanglam.imagepicker.listener.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.listener.OnImageSelectListener;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.BaseFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.FolderFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerActivity;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModel;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModelFactory;
import com.nguyenhoanglam.imagepicker.widget.ImagePickerToolbar;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J \u0010\u001a\u001a\u00020\u00162\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0012\u0010 \u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\b\u0010#\u001a\u00020\u0016H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0016J+\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.H\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u0016H\u0014J \u00101\u001a\u00020\u00162\u0016\u00102\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eH\u0016J\u0010\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u001dH\u0016J\b\u00105\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/nguyenhoanglam/imagepicker/listener/OnFolderClickListener;", "Lcom/nguyenhoanglam/imagepicker/listener/OnImageSelectListener;", "()V", "backClickListener", "Landroid/view/View$OnClickListener;", "binding", "Lcom/nguyenhoanglam/imagepicker/databinding/ImagepickerActivityImagepickerBinding;", "cameraClickListener", "cameraModule", "Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraModule;", "config", "Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;", "doneClickListener", "resultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "viewModel", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerViewModel;", "captureImage", "", "captureImageWithPermission", "fetchData", "fetchDataWithPermission", "finishPickImages", "images", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDone", "onFolderClick", "folder", "Lcom/nguyenhoanglam/imagepicker/model/Folder;", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "onSelectedImagesChanged", "selectedImages", "onSingleModeImageSelected", "image", "setupViews", "imagepicker_release"})
public final class ImagePickerActivity
extends AppCompatActivity
implements OnFolderClickListener,
OnImageSelectListener {
    private ImagepickerActivityImagepickerBinding binding;
    private ImagePickerConfig config;
    private ImagePickerViewModel viewModel;
    @NotNull
    private final CameraModule cameraModule = new CameraModule();
    @NotNull
    private final View.OnClickListener backClickListener = arg_0 -> ImagePickerActivity.backClickListener$lambda-0(this, arg_0);
    @NotNull
    private final View.OnClickListener cameraClickListener = arg_0 -> ImagePickerActivity.cameraClickListener$lambda-1(this, arg_0);
    @NotNull
    private final View.OnClickListener doneClickListener = arg_0 -> ImagePickerActivity.doneClickListener$lambda-2(this, arg_0);
    @NotNull
    private final ActivityResultLauncher<Intent> resultLauncher;

    public ImagePickerActivity() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> ImagePickerActivity.resultLauncher$lambda-3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.resultLauncher = activityResultLauncher;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        ImagePickerConfig imagePickerConfig;
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null) {
            this.finish();
            return;
        }
        Parcelable parcelable = this.getIntent().getParcelableExtra("ImagePickerConfig");
        Intrinsics.checkNotNull((Object)parcelable);
        this.config = (ImagePickerConfig)parcelable;
        ImagePickerConfig imagePickerConfig2 = this.config;
        if (imagePickerConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig2 = null;
        }
        imagePickerConfig2.initDefaultValues((Context)this);
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            ImagePickerConfig imagePickerConfig3 = this.config;
            if (imagePickerConfig3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig3 = null;
            }
            window.setStatusBarColor(Color.parseColor((String)imagePickerConfig3.getStatusBarColor()));
            WindowCompat.setDecorFitsSystemWindows((Window)this.getWindow(), (boolean)false);
            WindowInsetsControllerCompat windowInsetsControllerCompat = new WindowInsetsControllerCompat(this.getWindow(), this.getWindow().getDecorView());
            ImagePickerConfig imagePickerConfig4 = this.config;
            if (imagePickerConfig4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig4 = null;
            }
            windowInsetsControllerCompat.setAppearanceLightStatusBars(imagePickerConfig4.isLightStatusBar());
        }
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = ImagepickerActivityImagepickerBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)imagepickerActivityImagepickerBinding, (String)"inflate(layoutInflater)");
        this.binding = imagepickerActivityImagepickerBinding;
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding2 = this.binding;
        if (imagepickerActivityImagepickerBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityImagepickerBinding2 = null;
        }
        this.setContentView((View)imagepickerActivityImagepickerBinding2.getRoot());
        ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)this;
        Application application = this.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"this.application");
        this.viewModel = (ImagePickerViewModel)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)new ImagePickerViewModelFactory(application)).get(ImagePickerViewModel.class);
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        if ((imagePickerConfig = this.config) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        imagePickerViewModel.setConfig(imagePickerConfig);
        ImagePickerViewModel imagePickerViewModel2 = this.viewModel;
        if (imagePickerViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel2 = null;
        }
        imagePickerViewModel2.getSelectedImages().observe((LifecycleOwner)this, arg_0 -> ImagePickerActivity.onCreate$lambda-4(this, arg_0));
        this.setupViews();
    }

    protected void onResume() {
        super.onResume();
        this.fetchDataWithPermission();
    }

    private final void setupViews() {
        BaseFragment baseFragment;
        ImagePickerToolbar imagePickerToolbar;
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
        if (imagepickerActivityImagepickerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityImagepickerBinding = null;
        }
        ImagePickerToolbar $this$setupViews_u24lambda_u2d5 = imagePickerToolbar = imagepickerActivityImagepickerBinding.toolbar;
        boolean bl = false;
        ImagePickerConfig imagePickerConfig = this.config;
        if (imagePickerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        $this$setupViews_u24lambda_u2d5.config(imagePickerConfig);
        $this$setupViews_u24lambda_u2d5.setOnBackClickListener(this.backClickListener);
        $this$setupViews_u24lambda_u2d5.setOnCameraClickListener(this.cameraClickListener);
        $this$setupViews_u24lambda_u2d5.setOnDoneClickListener(this.doneClickListener);
        ImagePickerConfig imagePickerConfig2 = this.config;
        if (imagePickerConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig2 = null;
        }
        if (imagePickerConfig2.isFolderMode()) {
            ImagePickerConfig imagePickerConfig3 = this.config;
            if (imagePickerConfig3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig3 = null;
            }
            baseFragment = FolderFragment.Companion.newInstance(imagePickerConfig3.getFolderGridCount());
        } else {
            ImagePickerConfig imagePickerConfig4 = this.config;
            if (imagePickerConfig4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig4 = null;
            }
            baseFragment = ImageFragment.Companion.newInstance(imagePickerConfig4.getImageGridCount());
        }
        BaseFragment initialFragment = baseFragment;
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragmentContainer, (Fragment)initialFragment).commit();
    }

    private final void fetchDataWithPermission() {
        String[] stringArray = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
        String[] permissions = stringArray;
        PermissionHelper.INSTANCE.checkPermission((Activity)this, "android.permission.READ_EXTERNAL_STORAGE", new PermissionHelper.PermissionAskListener(this, permissions){
            final /* synthetic */ ImagePickerActivity this$0;
            final /* synthetic */ String[] $permissions;
            {
                this.this$0 = $receiver;
                this.$permissions = $permissions;
            }

            public void onNeedPermission() {
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this.this$0, this.$permissions, 1000);
            }

            public void onPermissionPreviouslyDenied() {
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this.this$0, this.$permissions, 1000);
            }

            public void onPermissionDisabled() {
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = ImagePickerActivity.access$getBinding$p(this.this$0);
                if (imagepickerActivityImagepickerBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding = null;
                }
                imagepickerActivityImagepickerBinding.snackbar.show(R.string.imagepicker_msg_no_external_storage_permission, arg_0 -> fetchDataWithPermission.1.onPermissionDisabled$lambda-0(this.this$0, arg_0));
            }

            public void onPermissionGranted() {
                ImagePickerActivity.access$fetchData(this.this$0);
            }

            private static final void onPermissionDisabled$lambda-0(ImagePickerActivity this$0, View it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                PermissionHelper.INSTANCE.openAppSettings((Activity)this$0);
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        switch (requestCode) {
            case 1000: {
                if (PermissionHelper.INSTANCE.hasGranted(grantResults)) {
                    this.fetchData();
                    break;
                }
                this.finish();
                break;
            }
            case 1001: {
                if (!PermissionHelper.INSTANCE.hasGranted(grantResults)) break;
                this.captureImage();
                break;
            }
            default: {
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }

    private final void fetchData() {
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        imagePickerViewModel.fetchImages();
    }

    public void onBackPressed() {
        super.onBackPressed();
        Fragment fragment = this.getSupportFragmentManager().findFragmentById(R.id.fragmentContainer);
        if (fragment != null && fragment instanceof FolderFragment) {
            ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
            if (imagepickerActivityImagepickerBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                imagepickerActivityImagepickerBinding = null;
            }
            ImagePickerToolbar imagePickerToolbar = imagepickerActivityImagepickerBinding.toolbar;
            ImagePickerConfig imagePickerConfig = this.config;
            if (imagePickerConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig = null;
            }
            imagePickerToolbar.setTitle(imagePickerConfig.getFolderTitle());
        }
    }

    private final void onDone() {
        ArrayList selectedImages;
        ArrayList arrayList;
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        if ((arrayList = (selectedImages = (ArrayList)imagePickerViewModel.getSelectedImages().getValue())) == null) {
            arrayList = new ArrayList();
        }
        this.finishPickImages(arrayList);
    }

    private final void captureImageWithPermission() {
        if (DeviceHelper.INSTANCE.isMinSdk29()) {
            this.captureImage();
            return;
        }
        String[] stringArray = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        String[] permissions = stringArray;
        PermissionHelper.INSTANCE.checkPermission((Activity)this, "android.permission.WRITE_EXTERNAL_STORAGE", new PermissionHelper.PermissionAskListener(this, permissions){
            final /* synthetic */ ImagePickerActivity this$0;
            final /* synthetic */ String[] $permissions;
            {
                this.this$0 = $receiver;
                this.$permissions = $permissions;
            }

            public void onNeedPermission() {
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this.this$0, this.$permissions, 1001);
            }

            public void onPermissionPreviouslyDenied() {
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this.this$0, this.$permissions, 1001);
            }

            public void onPermissionDisabled() {
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = ImagePickerActivity.access$getBinding$p(this.this$0);
                if (imagepickerActivityImagepickerBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding = null;
                }
                imagepickerActivityImagepickerBinding.snackbar.show(R.string.imagepicker_msg_no_external_storage_permission, arg_0 -> captureImageWithPermission.1.onPermissionDisabled$lambda-0(this.this$0, arg_0));
            }

            public void onPermissionGranted() {
                this.this$0.captureImage();
            }

            private static final void onPermissionDisabled$lambda-0(ImagePickerActivity this$0, View it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                PermissionHelper.INSTANCE.openAppSettings((Activity)this$0);
            }
        });
    }

    public final void captureImage() {
        Intent intent;
        if (!DeviceHelper.INSTANCE.checkCameraAvailability((Context)this)) {
            return;
        }
        Context context = (Context)this;
        ImagePickerConfig imagePickerConfig = this.config;
        if (imagePickerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        if ((intent = this.cameraModule.getCameraIntent(context, imagePickerConfig)) == null) {
            Context context2 = (Context)this;
            String string2 = this.getString(R.string.imagepicker_error_open_camera);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.imagepicker_error_open_camera)");
            ToastHelper.Companion.show$default(ToastHelper.Companion, context2, string2, 0, 4, null);
            return;
        }
        this.resultLauncher.launch((Object)intent);
    }

    private final void finishPickImages(ArrayList<Image> images) {
        Intent data = new Intent();
        data.putParcelableArrayListExtra("ImagePickerImages", images);
        this.setResult(-1, data);
        this.finish();
    }

    @Override
    public void onFolderClick(@NotNull Folder folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        long l = folder.getBucketId();
        ImagePickerConfig imagePickerConfig = this.config;
        if (imagePickerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        fragmentTransaction.add(R.id.fragmentContainer, (Fragment)ImageFragment.Companion.newInstance(l, imagePickerConfig.getImageGridCount())).addToBackStack(null).commit();
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
        if (imagepickerActivityImagepickerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityImagepickerBinding = null;
        }
        imagepickerActivityImagepickerBinding.toolbar.setTitle(folder.getName());
    }

    @Override
    public void onSelectedImagesChanged(@NotNull ArrayList<Image> selectedImages) {
        Intrinsics.checkNotNullParameter(selectedImages, (String)"selectedImages");
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        imagePickerViewModel.getSelectedImages().setValue(selectedImages);
    }

    @Override
    public void onSingleModeImageSelected(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.finishPickImages(ImageHelper.INSTANCE.singleListFromImage(image));
    }

    private static final void backClickListener$lambda-0(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onBackPressed();
    }

    private static final void cameraClickListener$lambda-1(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.captureImageWithPermission();
    }

    private static final void doneClickListener$lambda-2(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onDone();
    }

    private static final void resultLauncher$lambda-3(ImagePickerActivity this$0, ActivityResult result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (result.getResultCode() == -1) {
            CameraModule cameraModule = this$0.cameraModule;
            Context context = (Context)this$0;
            ImagePickerConfig imagePickerConfig = this$0.config;
            if (imagePickerConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig = null;
            }
            cameraModule.saveImage(context, imagePickerConfig, new OnImageReadyListener(this$0){
                final /* synthetic */ ImagePickerActivity this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onImageReady(@NotNull ArrayList<Image> images) {
                    Intrinsics.checkNotNullParameter(images, (String)"images");
                    ImagePickerActivity.access$fetchDataWithPermission(this.this$0);
                }

                public void onImageNotReady() {
                    ImagePickerActivity.access$fetchDataWithPermission(this.this$0);
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void onCreate$lambda-4(ImagePickerActivity this$0, ArrayList it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        v0 = this$0.binding;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            v0 = null;
        }
        v1 = v0.toolbar;
        v2 = this$0.config;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            v2 = null;
        }
        if (v2.isAlwaysShowDoneButton()) ** GOTO lbl-1000
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (((Collection)it).isEmpty() == false) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        v1.showDoneButton(v3);
    }

    public static final /* synthetic */ ImagepickerActivityImagepickerBinding access$getBinding$p(ImagePickerActivity $this) {
        return $this.binding;
    }

    public static final /* synthetic */ void access$fetchData(ImagePickerActivity $this) {
        $this.fetchData();
    }

    public static final /* synthetic */ void access$fetchDataWithPermission(ImagePickerActivity $this) {
        $this.fetchDataWithPermission();
    }
}

