/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import com.nguyenhoanglam.imagepicker.listener.OnImageLoaderListener;
import com.nguyenhoanglam.imagepicker.model.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFileLoader;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "futures", "Ljava/util/ArrayList;", "Ljava/util/concurrent/Future;", "Lkotlin/collections/ArrayList;", "projection", "", "", "[Ljava/lang/String;", "abortLoadImages", "", "loadDeviceImages", "listener", "Lcom/nguyenhoanglam/imagepicker/listener/OnImageLoaderListener;", "Companion", "ImageLoadRunnable", "imagepicker_release"})
public final class ImageFileLoader {
    private final String[] projection;
    private final ExecutorService executorService;
    private final ArrayList<Future<?>> futures;
    private final Context context;
    public static final Companion Companion = new Companion(null);

    public final void loadDeviceImages(@NotNull OnImageLoaderListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Future<?> future = this.executorService.submit(new ImageLoadRunnable(listener));
        this.futures.add(future);
    }

    public final void abortLoadImages() {
        for (Future<?> future : this.futures) {
            future.cancel(true);
        }
        this.futures.clear();
    }

    public ImageFileLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.projection = new String[]{"_id", "_display_name", "_data", "bucket_id", "bucket_display_name"};
        this.executorService = Executors.newSingleThreadExecutor();
        ImageFileLoader imageFileLoader = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        imageFileLoader.futures = arrayList;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFileLoader$ImageLoadRunnable;", "Ljava/lang/Runnable;", "listener", "Lcom/nguyenhoanglam/imagepicker/listener/OnImageLoaderListener;", "(Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFileLoader;Lcom/nguyenhoanglam/imagepicker/listener/OnImageLoaderListener;)V", "run", "", "imagepicker_release"})
    private final class ImageLoadRunnable
    implements Runnable {
        private final OnImageLoaderListener listener;

        @Override
        public void run() {
            Cursor cursor = ImageFileLoader.this.context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, ImageFileLoader.this.projection, null, null, "date_added DESC");
            if (cursor == null) {
                this.listener.onFailed(new NullPointerException());
                return;
            }
            int idColumn = cursor.getColumnIndex("_id");
            int nameColumn = cursor.getColumnIndex("_display_name");
            int dataColumn = cursor.getColumnIndex("_data");
            int bucketIdColumn = cursor.getColumnIndex("bucket_id");
            int bucketNameColumn = cursor.getColumnIndex("bucket_display_name");
            boolean bl = false;
            ArrayList<Image> images = new ArrayList<Image>();
            if (cursor.moveToFirst()) {
                do {
                    Uri uri;
                    if (Thread.interrupted()) {
                        this.listener.onFailed(new NullPointerException());
                        return;
                    }
                    long id2 = cursor.getLong(idColumn);
                    String name = cursor.getString(nameColumn);
                    String path = cursor.getString(dataColumn);
                    long bucketId = cursor.getLong(bucketIdColumn);
                    String bucketName = cursor.getString(bucketNameColumn);
                    File file = Companion.makeSafeFile(path);
                    if (file == null || !file.exists() || name == null || path == null || bucketName == null) continue;
                    Uri uri2 = uri = ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)id2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
                    Image image = new Image(id2, name, uri2, path, bucketId, bucketName);
                    images.add(image);
                } while (cursor.moveToNext());
            }
            cursor.close();
            this.listener.onImageLoaded(images);
            Thread.interrupted();
        }

        public ImageLoadRunnable(OnImageLoaderListener listener) {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            this.listener = listener;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFileLoader$Companion;", "", "()V", "makeSafeFile", "Ljava/io/File;", "path", "", "imagepicker_release"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final File makeSafeFile(String path) {
            if (path == null) return null;
            Object object = path;
            boolean bl = false;
            if (object.length() == 0) {
                return null;
            }
            boolean bl2 = false;
            if (bl2) {
                return null;
            }
            try {
                object = new File(path);
            }
            catch (Exception ignored) {
                return null;
            }
            CharSequence charSequence = object;
            return charSequence;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

