/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.helper.LayoutManagerHelper;
import com.nguyenhoanglam.imagepicker.listener.OnImageSelectListener;
import com.nguyenhoanglam.imagepicker.model.CallbackStatus;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.Result;
import com.nguyenhoanglam.imagepicker.ui.adapter.ImagePickerAdapter;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModel;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModelFactory;
import com.nguyenhoanglam.imagepicker.widget.GridSpacingItemDecoration;
import com.nguyenhoanglam.imagepicker.widget.ProgressWheel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\r\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J&\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010!\u001a\u00020\u0012H\u0002R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment;", "Landroidx/fragment/app/Fragment;", "()V", "bucketId", "", "Ljava/lang/Long;", "gridLayoutManager", "Landroidx/recyclerview/widget/GridLayoutManager;", "imageAdapter", "Lcom/nguyenhoanglam/imagepicker/ui/adapter/ImagePickerAdapter;", "itemDecoration", "Lcom/nguyenhoanglam/imagepicker/widget/GridSpacingItemDecoration;", "selectedImageObserver", "com/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment$selectedImageObserver$1", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment$selectedImageObserver$1;", "viewModel", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerViewModel;", "handleResult", "", "result", "Lcom/nguyenhoanglam/imagepicker/model/Result;", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "updateViewsOnConfigurationChanged", "Companion", "imagepicker_release"})
public final class ImageFragment
extends Fragment {
    private Long bucketId;
    private ImagePickerViewModel viewModel;
    private ImagePickerAdapter imageAdapter;
    private GridLayoutManager gridLayoutManager;
    private GridSpacingItemDecoration itemDecoration;
    private final selectedImageObserver.1 selectedImageObserver = new Observer<ArrayList<Image>>(this){
        final /* synthetic */ ImageFragment this$0;

        public void onChanged(@NotNull ArrayList<Image> it) {
            Intrinsics.checkParameterIsNotNull(it, (String)"it");
            ImageFragment.access$getImageAdapter$p(this.this$0).setSelectedImages(it);
            ImageFragment.access$getViewModel$p(this.this$0).getSelectedImages().removeObserver((Observer)this);
        }
        {
            this.this$0 = $outer;
        }
    };
    @NotNull
    public static final String BUCKET_ID = "BucketId";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        ImagePickerViewModel imagePickerViewModel;
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        this.bucketId = bundle != null ? Long.valueOf(bundle.getLong(BUCKET_ID)) : null;
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            Intrinsics.throwNpe();
        }
        FragmentActivity fragmentActivity2 = fragmentActivity;
        ImageFragment imageFragment = this;
        boolean bl = false;
        boolean bl2 = false;
        FragmentActivity $this$run = fragmentActivity2;
        boolean bl3 = false;
        ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)$this$run;
        FragmentActivity fragmentActivity3 = this.getActivity();
        if (fragmentActivity3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity3, (String)"activity!!");
        Application application = fragmentActivity3.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"activity!!.application");
        ViewModel viewModel = new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)new ImagePickerViewModelFactory(application)).get(ImagePickerViewModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewModel, (String)"ViewModelProvider(this, \u2026kerViewModel::class.java)");
        ImagePickerViewModel imagePickerViewModel2 = imagePickerViewModel = (ImagePickerViewModel)viewModel;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)imagePickerViewModel2), (String)"activity!!.run {\n       \u2026el::class.java)\n        }");
        imageFragment.viewModel = imagePickerViewModel2;
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        View root = inflater.inflate(R.layout.imagepicker_fragment, container, false);
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        root.setBackgroundColor(imagePickerViewModel.getConfig().getBackgroundColor());
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"activity!!");
        Context context = (Context)fragmentActivity;
        ImagePickerViewModel imagePickerViewModel2 = this.viewModel;
        if (imagePickerViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        FragmentActivity fragmentActivity2 = this.getActivity();
        if (fragmentActivity2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.nguyenhoanglam.imagepicker.listener.OnImageSelectListener");
        }
        this.imageAdapter = new ImagePickerAdapter(context, imagePickerViewModel2.getConfig(), (OnImageSelectListener)fragmentActivity2);
        Context context2 = this.getContext();
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context!!");
        GridLayoutManager gridLayoutManager = this.gridLayoutManager = LayoutManagerHelper.newInstance$default(LayoutManagerHelper.INSTANCE, context2, false, 2, null);
        if (gridLayoutManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
        }
        int n = gridLayoutManager.getSpanCount();
        GridLayoutManager gridLayoutManager2 = this.gridLayoutManager;
        if (gridLayoutManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
        }
        this.itemDecoration = new GridSpacingItemDecoration(n, gridLayoutManager2.getSpanCount(), false);
        View view = root;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"root");
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        boolean bl = false;
        boolean bl2 = false;
        RecyclerView $this$with = recyclerView;
        boolean bl3 = false;
        RecyclerView recyclerView2 = $this$with;
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"this");
        GridLayoutManager gridLayoutManager3 = this.gridLayoutManager;
        if (gridLayoutManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
        }
        recyclerView2.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager3);
        $this$with.setHasFixedSize(true);
        GridSpacingItemDecoration gridSpacingItemDecoration = this.itemDecoration;
        if (gridSpacingItemDecoration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDecoration");
        }
        $this$with.addItemDecoration((RecyclerView.ItemDecoration)gridSpacingItemDecoration);
        ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
        if (imagePickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
        }
        $this$with.setAdapter((RecyclerView.Adapter)imagePickerAdapter);
        ImagePickerViewModel imagePickerViewModel3 = this.viewModel;
        if (imagePickerViewModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        imagePickerViewModel3.getResult().observe(this.getViewLifecycleOwner(), (Observer)new Observer<Result>(this){
            final /* synthetic */ ImageFragment this$0;

            public final void onChanged(Result it) {
                Result result = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"it");
                ImageFragment.access$handleResult(this.this$0, result);
            }
            {
                this.this$0 = imageFragment;
            }
        });
        ImagePickerViewModel imagePickerViewModel4 = this.viewModel;
        if (imagePickerViewModel4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        imagePickerViewModel4.getSelectedImages().observe(this.getViewLifecycleOwner(), (Observer)this.selectedImageObserver);
        return root;
    }

    private final void handleResult(Result result) {
        if (result.getStatus() instanceof CallbackStatus.SUCCESS) {
            ArrayList<Image> images = ImageHelper.INSTANCE.filterImages(result.getImages(), this.bucketId);
            Collection collection = images;
            boolean bl = false;
            if (!collection.isEmpty()) {
                ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
                if (imagePickerAdapter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                }
                imagePickerAdapter.setData((List<Image>)images);
                RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recyclerView);
                Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recyclerView");
                recyclerView.setVisibility(0);
            } else {
                RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recyclerView);
                Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recyclerView");
                recyclerView.setVisibility(8);
            }
        } else {
            RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recyclerView);
            Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recyclerView");
            recyclerView.setVisibility(8);
        }
        TextView textView = (TextView)this._$_findCachedViewById(R.id.emptyText);
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"emptyText");
        textView.setVisibility(result.getStatus() instanceof CallbackStatus.SUCCESS && result.getImages().isEmpty() ? 0 : 8);
        ProgressWheel progressWheel = (ProgressWheel)this._$_findCachedViewById(R.id.progressWheel);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)progressWheel), (String)"progressWheel");
        progressWheel.setVisibility(result.getStatus() instanceof CallbackStatus.FETCHING ? 0 : 8);
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkParameterIsNotNull((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        this.updateViewsOnConfigurationChanged();
    }

    private final void updateViewsOnConfigurationChanged() {
        Context context = this.getContext();
        if (context == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context!!");
        int newSpanCount = LayoutManagerHelper.INSTANCE.getSpanCountForCurrentConfiguration(context, false);
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recyclerView);
        GridSpacingItemDecoration gridSpacingItemDecoration = this.itemDecoration;
        if (gridSpacingItemDecoration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDecoration");
        }
        recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)gridSpacingItemDecoration);
        this.itemDecoration = new GridSpacingItemDecoration(newSpanCount, newSpanCount, false);
        GridLayoutManager gridLayoutManager = this.gridLayoutManager;
        if (gridLayoutManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
        }
        gridLayoutManager.setSpanCount(newSpanCount);
        RecyclerView recyclerView2 = (RecyclerView)this._$_findCachedViewById(R.id.recyclerView);
        GridSpacingItemDecoration gridSpacingItemDecoration2 = this.itemDecoration;
        if (gridSpacingItemDecoration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDecoration");
        }
        recyclerView2.addItemDecoration((RecyclerView.ItemDecoration)gridSpacingItemDecoration2);
    }

    public static final /* synthetic */ void access$handleResult(ImageFragment $this, Result result) {
        $this.handleResult(result);
    }

    public static final /* synthetic */ ImagePickerAdapter access$getImageAdapter$p(ImageFragment $this) {
        ImagePickerAdapter imagePickerAdapter = $this.imageAdapter;
        if (imagePickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
        }
        return imagePickerAdapter;
    }

    public static final /* synthetic */ void access$setImageAdapter$p(ImageFragment $this, ImagePickerAdapter imagePickerAdapter) {
        $this.imageAdapter = imagePickerAdapter;
    }

    public static final /* synthetic */ ImagePickerViewModel access$getViewModel$p(ImageFragment $this) {
        ImagePickerViewModel imagePickerViewModel = $this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        return imagePickerViewModel;
    }

    public static final /* synthetic */ void access$setViewModel$p(ImageFragment $this, ImagePickerViewModel imagePickerViewModel) {
        $this.viewModel = imagePickerViewModel;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment$Companion;", "", "()V", "BUCKET_ID", "", "newInstance", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment;", "bucketId", "", "imagepicker_release"})
    public static final class Companion {
        @NotNull
        public final ImageFragment newInstance(long bucketId) {
            ImageFragment fragment = new ImageFragment();
            Bundle args = new Bundle();
            args.putLong(ImageFragment.BUCKET_ID, bucketId);
            fragment.setArguments(args);
            return fragment;
        }

        @NotNull
        public final ImageFragment newInstance() {
            return new ImageFragment();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

