/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.SavePath;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraActivty;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerActivity;
import java.util.ArrayList;

public class ImagePicker {
    protected Config config;

    public ImagePicker(Builder builder) {
        this.config = builder.config;
    }

    public static Builder with(Activity activity) {
        return new ActivityBuilder(activity);
    }

    public static Builder with(Fragment fragment) {
        return new FragmentBuilder(fragment);
    }

    public static abstract class BaseBuilder {
        protected Config config = new Config();

        public BaseBuilder(Context context) {
            Resources resources = context.getResources();
            this.config.setCameraOnly(false);
            this.config.setMultipleMode(true);
            this.config.setFolderMode(true);
            this.config.setShowCamera(true);
            this.config.setMaxSize(Integer.MAX_VALUE);
            this.config.setDoneTitle(resources.getString(R.string.imagepicker_action_done));
            this.config.setFolderTitle(resources.getString(R.string.imagepicker_title_folder));
            this.config.setImageTitle(resources.getString(R.string.imagepicker_title_image));
            this.config.setLimitMessage(resources.getString(R.string.imagepicker_msg_limit_images));
            this.config.setSavePath(SavePath.DEFAULT);
            this.config.setAlwaysShowDoneButton(false);
            this.config.setKeepScreenOn(false);
            this.config.setSelectedImages(new ArrayList<Image>());
        }
    }

    public static abstract class Builder
    extends BaseBuilder {
        public Builder(Activity activity) {
            super((Context)activity);
        }

        public Builder(Fragment fragment) {
            super(fragment.getContext());
        }

        public Builder setToolbarColor(String toolbarColor) {
            this.config.setToolbarColor(toolbarColor);
            return this;
        }

        public Builder setStatusBarColor(String statusBarColor) {
            this.config.setStatusBarColor(statusBarColor);
            return this;
        }

        public Builder setToolbarTextColor(String toolbarTextColor) {
            this.config.setToolbarTextColor(toolbarTextColor);
            return this;
        }

        public Builder setToolbarIconColor(String toolbarIconColor) {
            this.config.setToolbarIconColor(toolbarIconColor);
            return this;
        }

        public Builder setProgressBarColor(String progressBarColor) {
            this.config.setProgressBarColor(progressBarColor);
            return this;
        }

        public Builder setBackgroundColor(String backgroundColor) {
            this.config.setBackgroundColor(backgroundColor);
            return this;
        }

        public Builder setCameraOnly(boolean isCameraOnly) {
            this.config.setCameraOnly(isCameraOnly);
            return this;
        }

        public Builder setMultipleMode(boolean isMultipleMode) {
            this.config.setMultipleMode(isMultipleMode);
            return this;
        }

        public Builder setFolderMode(boolean isFolderMode) {
            this.config.setFolderMode(isFolderMode);
            return this;
        }

        public Builder setShowCamera(boolean isShowCamera) {
            this.config.setShowCamera(isShowCamera);
            return this;
        }

        public Builder setMaxSize(int maxSize) {
            this.config.setMaxSize(maxSize);
            return this;
        }

        public Builder setDoneTitle(String doneTitle) {
            this.config.setDoneTitle(doneTitle);
            return this;
        }

        public Builder setFolderTitle(String folderTitle) {
            this.config.setFolderTitle(folderTitle);
            return this;
        }

        public Builder setImageTitle(String imageTitle) {
            this.config.setImageTitle(imageTitle);
            return this;
        }

        public Builder setLimitMessage(String message) {
            this.config.setLimitMessage(message);
            return this;
        }

        public Builder setSavePath(String path) {
            this.config.setSavePath(new SavePath(path, false));
            return this;
        }

        public Builder setAlwaysShowDoneButton(boolean isAlwaysShowDoneButton) {
            this.config.setAlwaysShowDoneButton(isAlwaysShowDoneButton);
            return this;
        }

        public Builder setKeepScreenOn(boolean keepScreenOn) {
            this.config.setKeepScreenOn(keepScreenOn);
            return this;
        }

        public Builder setSelectedImages(ArrayList<Image> selectedImages) {
            this.config.setSelectedImages(selectedImages);
            return this;
        }

        public abstract void start();

        public abstract Intent getIntent();
    }

    static class FragmentBuilder
    extends Builder {
        private Fragment fragment;

        public FragmentBuilder(Fragment fragment) {
            super(fragment);
            this.fragment = fragment;
        }

        @Override
        public void start() {
            Intent intent = this.getIntent();
            if (!this.config.isCameraOnly()) {
                this.fragment.startActivityForResult(intent, 100);
            } else {
                this.fragment.getActivity().overridePendingTransition(0, 0);
                this.fragment.startActivityForResult(intent, 100);
            }
        }

        @Override
        public Intent getIntent() {
            Intent intent;
            if (!this.config.isCameraOnly()) {
                intent = new Intent((Context)this.fragment.getActivity(), ImagePickerActivity.class);
                intent.putExtra("ImagePickerConfig", (Parcelable)this.config);
            } else {
                intent = new Intent((Context)this.fragment.getActivity(), CameraActivty.class);
                intent.putExtra("ImagePickerConfig", (Parcelable)this.config);
                intent.addFlags(65536);
            }
            return intent;
        }
    }

    static class ActivityBuilder
    extends Builder {
        private Activity activity;

        public ActivityBuilder(Activity activity) {
            super(activity);
            this.activity = activity;
        }

        @Override
        public void start() {
            Intent intent = this.getIntent();
            if (!this.config.isCameraOnly()) {
                this.activity.startActivityForResult(intent, 100);
            } else {
                this.activity.overridePendingTransition(0, 0);
                this.activity.startActivityForResult(intent, 100);
            }
        }

        @Override
        public Intent getIntent() {
            Intent intent;
            if (!this.config.isCameraOnly()) {
                intent = new Intent((Context)this.activity, ImagePickerActivity.class);
                intent.putExtra("ImagePickerConfig", (Parcelable)this.config);
            } else {
                intent = new Intent((Context)this.activity, CameraActivty.class);
                intent.putExtra("ImagePickerConfig", (Parcelable)this.config);
                intent.addFlags(65536);
            }
            return intent;
        }
    }
}

