/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.listeners.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.model.Folder;
import java.util.List;

public class FolderPickerAdapter
extends RecyclerView.Adapter<FolderViewHolder> {
    private Context context;
    private LayoutInflater inflater;
    private final OnFolderClickListener folderClickListener;
    private List<Folder> folders;

    public FolderPickerAdapter(Context context, OnFolderClickListener folderClickListener) {
        this.context = context;
        this.folderClickListener = folderClickListener;
        this.inflater = LayoutInflater.from((Context)this.context);
    }

    public FolderViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = this.inflater.inflate(R.layout.item_folder, parent, false);
        return new FolderViewHolder(itemView);
    }

    public void onBindViewHolder(FolderViewHolder holder, int position) {
        final Folder folder = this.folders.get(position);
        Glide.with((Context)this.context).load(folder.getImages().get(0).getPath()).placeholder(R.drawable.folder_placeholder).error(R.drawable.folder_placeholder).into(holder.image);
        holder.name.setText((CharSequence)this.folders.get(position).getFolderName());
        holder.number.setText((CharSequence)String.valueOf(this.folders.get(position).getImages().size()));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FolderPickerAdapter.this.folderClickListener != null) {
                    FolderPickerAdapter.this.folderClickListener.onFolderClick(folder);
                }
            }
        });
    }

    public void setData(List<Folder> folders) {
        this.folders = folders;
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.folders.size();
    }

    public static class FolderViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView image;
        private TextView name;
        private TextView number;

        public FolderViewHolder(View itemView) {
            super(itemView);
            this.image = (ImageView)itemView.findViewById(R.id.image);
            this.name = (TextView)itemView.findViewById(R.id.tv_name);
            this.number = (TextView)itemView.findViewById(R.id.tv_number);
        }
    }
}

