/*
 * Decompiled with CFR 0.152.
 */
package txtai;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;
import txtai.API;

public class Summary {
    private String url;
    private Remote api;

    public Summary(String url) {
        this.url = url;
        this.api = API.create(this.url, Remote.class);
    }

    public String summary(String text, int minlength, int maxlength) throws IOException {
        return (String)this.api.summary(text, minlength != -1 ? Integer.valueOf(minlength) : null, maxlength != -1 ? Integer.valueOf(maxlength) : null).execute().body();
    }

    public List<String> batchsummary(List<String> texts, int minlength, int maxlength) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("texts", texts);
        if (minlength != -1) {
            params.put("minlength", minlength);
        }
        if (maxlength != -1) {
            params.put("maxlength", maxlength);
        }
        return (List)this.api.batchsummary(params).execute().body();
    }

    public static interface Remote {
        @GET(value="summary")
        public Call<String> summary(@Query(value="text") String var1, @Query(value="minlength") Integer var2, @Query(value="maxlength") Integer var3);

        @POST(value="batchsummary")
        public Call<List<String>> batchsummary(@Body HashMap var1);
    }
}

