/*
 * Decompiled with CFR 0.152.
 */
package txtai;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;
import txtai.API;

public class Extractor {
    private String url;
    private Remote api;

    public Extractor(String url) {
        this.url = url;
        this.api = API.create(this.url, Remote.class);
    }

    public List<Answer> extract(List<Question> queue, List<String> texts) throws IOException {
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
        params.put("queue", queue);
        params.put("texts", texts);
        return (List)this.api.extract(params).execute().body();
    }

    public static class Answer {
        public String name;
        public String answer;

        public Answer(String name, String answer) {
            this.name = name;
            this.answer = answer;
        }

        public String toString() {
            return this.name + " " + this.answer;
        }
    }

    public static class Question {
        public String name;
        public String query;
        public String question;
        public boolean snippet;

        public Question(String name, String query, String question, boolean snippet) {
            this.name = name;
            this.query = query;
            this.question = question;
            this.snippet = snippet;
        }
    }

    public static interface Remote {
        @POST(value="extract")
        public Call<List<Answer>> extract(@Body HashMap var1);
    }
}

