/*
 * Decompiled with CFR 0.152.
 */
package txtai;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;
import txtai.API;

public class Embeddings {
    private String url;
    private Remote api;

    public Embeddings(String url) {
        this.url = url;
        this.api = API.create(this.url, Remote.class);
    }

    public List<SearchResult> search(String query, int limit) throws IOException {
        return (List)this.api.search(query, limit).execute().body();
    }

    public List<List<SearchResult>> batchsearch(List<String> queries, List<String> texts) throws IOException {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("queries", queries);
        params.put("texts", texts);
        return (List)this.api.batchsearch(params).execute().body();
    }

    public void add(List documents) throws IOException {
        this.api.add(documents).execute();
    }

    public void index() throws IOException {
        this.api.index().execute();
    }

    public void upsert() throws IOException {
        this.api.upsert().execute();
    }

    public List<String> delete(List<String> ids) throws IOException {
        return (List)this.api.delete(ids).execute().body();
    }

    public int count() throws IOException {
        return (Integer)this.api.count().execute().body();
    }

    public List<API.IndexResult> similarity(String query, List<String> texts) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        params.put("texts", texts);
        return (List)this.api.similarity(params).execute().body();
    }

    public List<List<API.IndexResult>> batchsimilarity(List<String> queries, List<String> texts) throws IOException {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("queries", queries);
        params.put("texts", texts);
        return (List)this.api.batchsimilarity(params).execute().body();
    }

    public List<Double> transform(String text) throws IOException {
        return (List)this.api.transform(text).execute().body();
    }

    public List<List<Double>> batchtransform(List<String> texts) throws IOException {
        return (List)this.api.batchtransform(texts).execute().body();
    }

    public static class SearchResult {
        public String id;
        public double score;

        public SearchResult(String id, double score) {
            this.id = id;
            this.score = score;
        }
    }

    public static class Document {
        public String id;
        public String text;

        public Document(String id, String text) {
            this.id = id;
            this.text = text;
        }
    }

    public static interface Remote {
        @GET(value="search")
        public Call<List<SearchResult>> search(@Query(value="query") String var1, @Query(value="limit") int var2);

        @POST(value="batchsearch")
        public Call<List<List<SearchResult>>> batchsearch(@Body HashMap var1);

        @POST(value="add")
        public Call<Void> add(@Body List var1);

        @GET(value="index")
        public Call<Void> index();

        @GET(value="upsert")
        public Call<Void> upsert();

        @POST(value="delete")
        public Call<List<String>> delete(@Body List<String> var1);

        @GET(value="count")
        public Call<Integer> count();

        @POST(value="similarity")
        public Call<List<API.IndexResult>> similarity(@Body HashMap var1);

        @POST(value="batchsimilarity")
        public Call<List<List<API.IndexResult>>> batchsimilarity(@Body HashMap var1);

        @GET(value="transform")
        public Call<List<Double>> transform(@Query(value="text") String var1);

        @POST(value="batchtransform")
        public Call<List<List<Double>>> batchtransform(@Body List<String> var1);
    }
}

