/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import androidx.annotation.NonNull;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.herewhite.sdk.JsBridgeInterface;
import com.herewhite.sdk.SyncedStoreObject;
import com.herewhite.sdk.Utils;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.SDKError;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class SyncedStore {
    private final JsBridgeInterface bridge;
    private final HashMap<String, JsonObject> storages = new HashMap();
    private final HashMap<String, Class<SyncedStoreObject>> types = new HashMap();
    private final HashMap<String, CopyOnWriteArraySet<OnStateChangedListener>> listenersByName = new HashMap();

    public SyncedStore(JsBridgeInterface bridge) {
        this.bridge = bridge;
    }

    public <T extends SyncedStoreObject> void connectStorage(String name, T data, Promise<T> promise) {
        this.types.put(name, data.getClass());
        this.bridge.callHandler("store.connectStorage", new Object[]{name, data}, retValue -> {
            JsonObject state = Utils.fromJson(retValue, JsonObject.class);
            this.storages.put(name, state);
            promise.then(this.getStorageState(name));
        });
    }

    public <T extends SyncedStoreObject> T getStorageState(String name) {
        return (T)Utils.fromJson((JsonElement)this.storages.get(name), this.types.get(name));
    }

    public <T extends SyncedStoreObject> void getStorageState(String name, Promise<T> promise) {
        this.bridge.callHandler("store.getStorageState", new Object[]{name}, retValue -> {
            try {
                SyncedStoreObject state = Utils.fromJson(retValue, this.types.get(name));
                promise.then(state);
            }
            catch (Exception e) {
                promise.catchEx(SDKError.promiseError(e.getMessage()));
            }
        });
    }

    public <T extends SyncedStoreObject> void setStorageState(String name, T data) {
        this.bridge.callHandler("store.setStorageState", new Object[]{name, data});
    }

    public void disconnectStorage(String name) {
        this.bridge.callHandler("store.disconnectStorage", new Object[]{name});
        this.listenersByName.remove(name);
    }

    public void deleteStorage(String name) {
        this.bridge.callHandler("store.deleteStorage", new Object[]{name});
    }

    public void resetState(String name) {
        this.bridge.callHandler("store.resetState", new Object[]{name});
    }

    void fireStorageStateUpdate(String valueOf) {
        StorageStateUpdate stateUpdate = Utils.fromJson(valueOf, StorageStateUpdate.class);
        String name = stateUpdate.name;
        JsonObject data = stateUpdate.data;
        if (this.types.containsKey(name) && this.storages.containsKey(name)) {
            JsonObject newValueData = SyncedStore.getNewValueObject(data);
            Class<SyncedStoreObject> storeObjectClass = this.types.get(name);
            JsonObject merged = SyncedStore.mergeUpdate(this.storages.get(name).deepCopy(), newValueData);
            this.storages.put(stateUpdate.name, merged);
            SyncedStoreObject current = Utils.fromJson((JsonElement)merged, storeObjectClass);
            SyncedStoreObject modifyState = Utils.fromJson((JsonElement)newValueData, storeObjectClass);
            this.notifyStateChanged(stateUpdate.name, modifyState, current);
        }
    }

    private void notifyStateChanged(String name, SyncedStoreObject modifyState, SyncedStoreObject current) {
        CopyOnWriteArraySet<OnStateChangedListener> listeners = this.listenersByName.get(name);
        for (OnStateChangedListener listener : listeners) {
            listener.onStateChanged(modifyState, current);
        }
    }

    private static JsonObject getNewValueObject(JsonObject update) {
        JsonObject result = new JsonObject();
        for (String key : update.keySet()) {
            JsonObject updateItem = update.get(key).getAsJsonObject();
            if (updateItem.has("newValue")) {
                result.add(key, updateItem.get("newValue"));
                continue;
            }
            result.add(key, (JsonElement)JsonNull.INSTANCE);
        }
        return result;
    }

    private static JsonObject mergeUpdate(JsonObject object, JsonObject update) {
        for (String key : update.keySet()) {
            object.add(key, update.get(key));
        }
        return object;
    }

    public <T extends SyncedStoreObject> void addOnStateChangedListener(String name, @NonNull OnStateChangedListener<T> listener) {
        CopyOnWriteArraySet<OnStateChangedListener<Object>> listeners = this.listenersByName.get(name);
        if (listeners == null) {
            listeners = new CopyOnWriteArraySet();
            this.listenersByName.put(name, listeners);
        }
        listeners.add(listener);
    }

    public <T extends SyncedStoreObject> void removeOnStateChangedListener(String name, OnStateChangedListener<T> listener) {
        CopyOnWriteArraySet<OnStateChangedListener> listeners = this.listenersByName.get(name);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    static class StorageStateUpdate {
        public String name;
        public JsonObject data;

        StorageStateUpdate() {
        }
    }

    public static interface OnStateChangedListener<T extends SyncedStoreObject> {
        public void onStateChanged(T var1, T var2);
    }
}

