/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import com.herewhite.sdk.JsBridgeInterface;
import com.herewhite.sdk.Utils;
import wendu.dsbridge.DWebView;
import wendu.dsbridge.OnReturnValue;

public class WhiteboardView
extends DWebView
implements JsBridgeInterface {
    private static String entryUrl = "file:///android_asset/whiteboard/index.html";
    private boolean autoResize = true;
    private RefreshViewSizeStrategy delayStrategy;

    public WhiteboardView(Context context) {
        super(WhiteboardView.getFixedContext(context));
        this.init();
    }

    public WhiteboardView(Context context, AttributeSet attrs) {
        super(WhiteboardView.getFixedContext(context), attrs);
        this.init();
    }

    public static Context getFixedContext(Context context) {
        if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT < 23) {
            return context.createConfigurationContext(new Configuration());
        }
        return context;
    }

    protected void onSizeChanged(int w, int h, int ow, int oh) {
        super.onSizeChanged(w, h, ow, oh);
        if (this.isInEditMode()) {
            return;
        }
        if (this.autoResize) {
            this.delayStrategy.refreshViewSize();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.delayStrategy.onDetachedFromWindow();
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public static void setEntryUrl(String entryUrl) {
        WhiteboardView.entryUrl = entryUrl;
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        this.getSettings().setTextZoom(100);
        this.loadUrl(entryUrl);
        this.setWebChromeClient(new FixWebChromeClient());
        this.delayStrategy = new RefreshViewSizeStrategy(100);
    }

    @Override
    public <T> void callHandler(String method, Object[] args, OnReturnValue<T> handler) {
        super.callHandler(method, Utils.toBridgeMaps(args), handler);
    }

    @Override
    public void callHandler(String method, Object[] args) {
        this.callHandler(method, args, null);
    }

    @Override
    public <T> void callHandler(String method, OnReturnValue<T> handler) {
        this.callHandler(method, null, handler);
    }

    @Override
    public void callFocusView() {
        this.requestFocus();
    }

    private class RefreshViewSizeStrategy {
        private final int delay;
        private Runnable refreshViewSize = () -> WhiteboardView.this.callHandler("displayer.refreshViewSize", new Object[0]);

        RefreshViewSizeStrategy(int delay) {
            this.delay = delay;
        }

        public void refreshViewSize() {
            WhiteboardView.this.removeCallbacks(this.refreshViewSize);
            WhiteboardView.this.postDelayed(this.refreshViewSize, this.delay);
        }

        public void onDetachedFromWindow() {
            WhiteboardView.this.removeCallbacks(this.refreshViewSize);
        }
    }

    class FixWebChromeClient
    extends WebChromeClient {
        FixWebChromeClient() {
        }

        public Bitmap getDefaultVideoPoster() {
            try {
                int width = 100;
                int height = 50;
                return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (Exception e) {
                return super.getDefaultVideoPoster();
            }
        }
    }
}

