/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.herewhite.sdk.AudioMixerBridge;
import com.herewhite.sdk.AudioMixerImplement;
import com.herewhite.sdk.CommonCallback;
import com.herewhite.sdk.CommonCallbacks;
import com.herewhite.sdk.JsBridgeInterface;
import com.herewhite.sdk.Player;
import com.herewhite.sdk.PlayerJsInterfaceImpl;
import com.herewhite.sdk.PlayerListener;
import com.herewhite.sdk.Room;
import com.herewhite.sdk.RoomJsInterfaceImpl;
import com.herewhite.sdk.RoomListener;
import com.herewhite.sdk.RoomParams;
import com.herewhite.sdk.RtcJsInterfaceImpl;
import com.herewhite.sdk.SdkJsInterfaceImpl;
import com.herewhite.sdk.Utils;
import com.herewhite.sdk.WhiteSdkConfiguration;
import com.herewhite.sdk.domain.FontFace;
import com.herewhite.sdk.domain.PlayerConfiguration;
import com.herewhite.sdk.domain.PlayerTimeInfo;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.RoomPhase;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.domain.UrlInterrupter;
import org.json.JSONObject;
import wendu.dsbridge.OnReturnValue;

public class WhiteSdk {
    private static final Gson gson = new Gson();
    private final JsBridgeInterface bridge;
    private final RoomJsInterfaceImpl roomJsInterface;
    private final PlayerJsInterfaceImpl playerJsInterface;
    private final SdkJsInterfaceImpl sdkJsInterface;
    private RtcJsInterfaceImpl rtcJsInterface;
    private final int densityDpi;
    private final boolean onlyCallbackRemoteStateModify;
    @Nullable
    private AudioMixerImplement audioMixerImplement;

    public void setCommonCallbacks(CommonCallbacks commonCallbacks) {
        this.sdkJsInterface.setCommonCallbacks(commonCallbacks);
    }

    public AudioMixerImplement getAudioMixerImplement() {
        return this.audioMixerImplement;
    }

    public static String Version() {
        return "2.12.9";
    }

    public WhiteSdk(JsBridgeInterface bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration) {
        this(bridge, context, whiteSdkConfiguration, (CommonCallback)null);
    }

    public WhiteSdk(JsBridgeInterface bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration, @Nullable CommonCallback commonCallback) {
        this(bridge, context, whiteSdkConfiguration, commonCallback, null);
    }

    public WhiteSdk(JsBridgeInterface bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration, UrlInterrupter urlInterrupter) {
        this(bridge, context, whiteSdkConfiguration);
        this.sdkJsInterface.setUrlInterrupter(urlInterrupter);
    }

    public WhiteSdk(JsBridgeInterface bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration, @Nullable CommonCallback commonCallback, @Nullable AudioMixerBridge audioMixerBridge) {
        this.bridge = bridge;
        this.densityDpi = Utils.getDensityDpi(context);
        this.roomJsInterface = new RoomJsInterfaceImpl();
        this.playerJsInterface = new PlayerJsInterfaceImpl();
        this.sdkJsInterface = new SdkJsInterfaceImpl(commonCallback);
        this.onlyCallbackRemoteStateModify = whiteSdkConfiguration.isOnlyCallbackRemoteStateModify();
        if (audioMixerBridge != null) {
            this.audioMixerImplement = new AudioMixerImplement(bridge);
            this.rtcJsInterface = new RtcJsInterfaceImpl(audioMixerBridge);
            bridge.addJavascriptObject(this.rtcJsInterface, "rtc");
            whiteSdkConfiguration.setEnableRtcIntercept(true);
        }
        bridge.addJavascriptObject(this.sdkJsInterface, "sdk");
        bridge.addJavascriptObject(this.roomJsInterface, "room");
        bridge.addJavascriptObject(this.playerJsInterface, "player");
        WhiteSdkConfiguration copyConfig = Utils.deepCopy(whiteSdkConfiguration, WhiteSdkConfiguration.class);
        copyConfig.setOnlyCallbackRemoteStateModify(false);
        bridge.callHandler("sdk.newWhiteSdk", new Object[]{copyConfig});
    }

    public void joinRoom(RoomParams roomParams, Promise<Room> roomPromise) {
        this.joinRoom(roomParams, null, roomPromise);
    }

    public void joinRoom(RoomParams roomParams, RoomListener roomListener, Promise<Room> roomPromise) {
        Room room = new Room(roomParams.getUuid(), this.bridge, this.densityDpi, this.onlyCallbackRemoteStateModify);
        room.setRoomListener(roomListener);
        this.roomJsInterface.setRoom(room.getRoomDelegate());
        try {
            this.bridge.callHandler("sdk.joinRoom", new Object[]{roomParams}, roomString -> {
                JsonObject jsonObject = (JsonObject)gson.fromJson(roomString, JsonObject.class);
                SDKError promiseError = SDKError.promiseError(jsonObject);
                if (promiseError != null) {
                    roomPromise.catchEx(promiseError);
                } else {
                    JsonObject jsonState = jsonObject.getAsJsonObject("state");
                    Long observerId = jsonObject.get("observerId").getAsLong();
                    Boolean isWritable = jsonObject.get("isWritable").getAsBoolean();
                    room.setSyncRoomState(jsonState.toString());
                    room.setObserverId(observerId);
                    room.setWritable(isWritable);
                    room.setRoomPhase(RoomPhase.connected);
                    roomPromise.then(room);
                }
            });
        }
        catch (AssertionError a) {
            throw a;
        }
        catch (Exception e) {
            roomPromise.catchEx(new SDKError(e.getMessage()));
        }
    }

    public void createPlayer(PlayerConfiguration playerConfiguration, Promise<Player> playerPromise) {
        this.createPlayer(playerConfiguration, null, playerPromise);
    }

    public void createPlayer(PlayerConfiguration playerConfiguration, PlayerListener listener, Promise<Player> playerPromise) {
        Player player = new Player(playerConfiguration.getRoom(), this.bridge, this.densityDpi);
        player.setPlayerEventListener(listener);
        this.playerJsInterface.setPlayer(player.getDelegate());
        try {
            this.bridge.callHandler("sdk.replayRoom", new Object[]{playerConfiguration}, playString -> {
                JsonObject jsonObject = (JsonObject)gson.fromJson(playString, JsonObject.class);
                SDKError promiseError = SDKError.promiseError(jsonObject);
                if (promiseError != null) {
                    playerPromise.catchEx(promiseError);
                } else {
                    JsonObject timeInfo = jsonObject.getAsJsonObject("timeInfo");
                    PlayerTimeInfo playerTimeInfo = (PlayerTimeInfo)gson.fromJson(timeInfo.toString(), PlayerTimeInfo.class);
                    player.setPlayerTimeInfo(playerTimeInfo);
                    playerPromise.then(player);
                }
            });
        }
        catch (AssertionError a) {
            throw a;
        }
        catch (Exception e) {
            playerPromise.catchEx(new SDKError(e.getMessage()));
        }
    }

    public void isPlayable(PlayerConfiguration playerConfiguration, final Promise<Boolean> playablePromise) {
        this.bridge.callHandler("sdk.isPlayable", new Object[]{playerConfiguration}, new OnReturnValue<Boolean>(){

            public void onValue(Boolean retValue) {
                playablePromise.then(retValue);
            }
        });
    }

    public void setupFontFaces(FontFace[] fontFaces) {
        this.bridge.callHandler("sdk.updateNativeFontFaceCSS", new Object[]{fontFaces});
    }

    public void loadFontFaces(FontFace[] fontFaces, final Promise<JSONObject> loadPromise) {
        this.bridge.callHandler("sdk.asyncInsertFontFaces", new Object[]{fontFaces}, new OnReturnValue<JSONObject>(){

            public void onValue(JSONObject retValue) {
                loadPromise.then(retValue);
            }
        });
    }

    public void updateTextFont(String[] names) {
        this.bridge.callHandler("sdk.updateNativeTextareaFont", new Object[]{names});
    }

    public void releaseRoom() {
        this.roomJsInterface.setRoom(null);
    }

    public void releaseRoom(String uuid) {
        this.releaseRoom();
    }

    public void releasePlayer() {
        this.playerJsInterface.setPlayer(null);
    }

    public void releasePlayer(String uuid) {
        this.releasePlayer();
    }
}

