/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import com.herewhite.sdk.JsBridgeInterface;
import com.herewhite.sdk.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wendu.dsbridge.DWebView;
import wendu.dsbridge.OnReturnValue;

public class WhiteboardView
extends DWebView
implements JsBridgeInterface {
    public WhiteboardView(Context context) {
        super(WhiteboardView.getFixedContext(context));
        this.init(context, null);
    }

    public WhiteboardView(Context context, AttributeSet attrs) {
        super(WhiteboardView.getFixedContext(context), attrs);
        this.init(context, attrs);
    }

    public static Context getFixedContext(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return context.createConfigurationContext(new Configuration());
        }
        return context;
    }

    private void init(Context context, AttributeSet attrs) {
        this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        this.loadUrl("file:///android_asset/whiteboard/index.html");
        this.setWebChromeClient(new FixWebChromeClient());
    }

    private int getWebViewVersion() {
        String userAgent = this.getSettings().getUserAgentString();
        Pattern pattern = Pattern.compile("Chrome/([\\d]+)", 2);
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.find()) {
            String group = matcher.group(1);
            return Integer.valueOf(group);
        }
        return 0;
    }

    @Override
    public <T> void callHandler(String method, Object[] args, OnReturnValue<T> handler) {
        super.callHandler(method, Utils.toBridgeMaps(args), handler);
    }

    @Override
    public void callHandler(String method, Object[] args) {
        this.callHandler(method, args, null);
    }

    @Override
    public <T> void callHandler(String method, OnReturnValue<T> handler) {
        this.callHandler(method, null, handler);
    }

    class FixWebChromeClient
    extends WebChromeClient {
        FixWebChromeClient() {
        }

        public Bitmap getDefaultVideoPoster() {
            try {
                int width = 100;
                int height = 50;
                return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (Exception e) {
                return super.getDefaultVideoPoster();
            }
        }
    }
}

