/*
 * Decompiled with CFR 0.152.
 */
package wendu.dsbridge;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.GeolocationPermissions;
import android.webkit.JavascriptInterface;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import androidx.annotation.Keep;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import wendu.dsbridge.CompletionHandler;
import wendu.dsbridge.OnReturnValue;

public class DWebView
extends WebView {
    private static final String BRIDGE_NAME = "_dsbridge";
    private static final String LOG_TAG = "dsBridge";
    private static boolean isDebug = false;
    private Map<String, Object> javaScriptNamespaceInterfaces = new HashMap<String, Object>();
    private String APP_CACHE_DIRNAME;
    private int callID = 0;
    private WebChromeClient webChromeClient;
    private volatile boolean alertBoxBlock = true;
    private JavascriptCloseWindowListener javascriptCloseWindowListener = null;
    private ArrayList<CallInfo> callInfoList;
    private InnerJavascriptInterface innerJavascriptInterface = new InnerJavascriptInterface();
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    Map<Integer, OnReturnValue> handlerMap = new HashMap<Integer, OnReturnValue>();
    private WebChromeClient mWebChromeClient = new WebChromeClient(){

        public void onProgressChanged(WebView view, int newProgress) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onProgressChanged(view, newProgress);
            } else {
                super.onProgressChanged(view, newProgress);
            }
        }

        public void onReceivedTitle(WebView view, String title) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onReceivedTitle(view, title);
            } else {
                super.onReceivedTitle(view, title);
            }
        }

        public void onReceivedIcon(WebView view, Bitmap icon) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onReceivedIcon(view, icon);
            } else {
                super.onReceivedIcon(view, icon);
            }
        }

        public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onReceivedTouchIconUrl(view, url, precomposed);
            } else {
                super.onReceivedTouchIconUrl(view, url, precomposed);
            }
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onShowCustomView(view, callback);
            } else {
                super.onShowCustomView(view, callback);
            }
        }

        @TargetApi(value=14)
        public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onShowCustomView(view, requestedOrientation, callback);
            } else {
                super.onShowCustomView(view, requestedOrientation, callback);
            }
        }

        public void onHideCustomView() {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onHideCustomView();
            } else {
                super.onHideCustomView();
            }
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
            }
            return super.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
        }

        public void onRequestFocus(WebView view) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onRequestFocus(view);
            } else {
                super.onRequestFocus(view);
            }
        }

        public void onCloseWindow(WebView window) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onCloseWindow(window);
            } else {
                super.onCloseWindow(window);
            }
        }

        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            if (!DWebView.this.alertBoxBlock) {
                result.confirm();
            }
            return DWebView.this.webChromeClient != null && DWebView.this.webChromeClient.onJsAlert(view, url, message, result);
        }

        public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
            if (!DWebView.this.alertBoxBlock) {
                result.confirm();
            }
            return DWebView.this.webChromeClient != null && DWebView.this.webChromeClient.onJsConfirm(view, url, message, result);
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            String prefix;
            if (Build.VERSION.SDK_INT <= 16 && message.startsWith(prefix = "_dsbridge=")) {
                result.confirm(DWebView.this.innerJavascriptInterface.call(message.substring(prefix.length()), defaultValue));
                return true;
            }
            if (!DWebView.this.alertBoxBlock) {
                result.confirm();
            }
            return DWebView.this.webChromeClient != null && DWebView.this.webChromeClient.onJsPrompt(view, url, message, defaultValue, result);
        }

        public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.onJsBeforeUnload(view, url, message, result);
            }
            return super.onJsBeforeUnload(view, url, message, result);
        }

        public void onExceededDatabaseQuota(String url, String databaseIdentifier, long quota, long estimatedDatabaseSize, long totalQuota, WebStorage.QuotaUpdater quotaUpdater) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onExceededDatabaseQuota(url, databaseIdentifier, quota, estimatedDatabaseSize, totalQuota, quotaUpdater);
            } else {
                super.onExceededDatabaseQuota(url, databaseIdentifier, quota, estimatedDatabaseSize, totalQuota, quotaUpdater);
            }
        }

        public void onReachedMaxAppCacheSize(long requiredStorage, long quota, WebStorage.QuotaUpdater quotaUpdater) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onReachedMaxAppCacheSize(requiredStorage, quota, quotaUpdater);
            }
            super.onReachedMaxAppCacheSize(requiredStorage, quota, quotaUpdater);
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onGeolocationPermissionsShowPrompt(origin, callback);
            } else {
                super.onGeolocationPermissionsShowPrompt(origin, callback);
            }
        }

        public void onGeolocationPermissionsHidePrompt() {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onGeolocationPermissionsHidePrompt();
            } else {
                super.onGeolocationPermissionsHidePrompt();
            }
        }

        @TargetApi(value=21)
        public void onPermissionRequest(PermissionRequest request) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onPermissionRequest(request);
            } else {
                super.onPermissionRequest(request);
            }
        }

        @TargetApi(value=21)
        public void onPermissionRequestCanceled(PermissionRequest request) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onPermissionRequestCanceled(request);
            } else {
                super.onPermissionRequestCanceled(request);
            }
        }

        public boolean onJsTimeout() {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.onJsTimeout();
            }
            return super.onJsTimeout();
        }

        public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onConsoleMessage(message, lineNumber, sourceID);
            } else {
                super.onConsoleMessage(message, lineNumber, sourceID);
            }
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.onConsoleMessage(consoleMessage);
            }
            return super.onConsoleMessage(consoleMessage);
        }

        public Bitmap getDefaultVideoPoster() {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.getDefaultVideoPoster();
            }
            return super.getDefaultVideoPoster();
        }

        public View getVideoLoadingProgressView() {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.getVideoLoadingProgressView();
            }
            return super.getVideoLoadingProgressView();
        }

        public void getVisitedHistory(ValueCallback<String[]> callback) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.getVisitedHistory(callback);
            } else {
                super.getVisitedHistory(callback);
            }
        }

        @TargetApi(value=21)
        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.onShowFileChooser(webView, filePathCallback, fileChooserParams);
            }
            return super.onShowFileChooser(webView, filePathCallback, fileChooserParams);
        }

        @Keep
        @TargetApi(value=11)
        public void openFileChooser(ValueCallback valueCallback, String acceptType) {
            if (DWebView.this.webChromeClient instanceof FileChooser) {
                ((FileChooser)DWebView.this.webChromeClient).openFileChooser(valueCallback, acceptType);
            }
        }

        @Keep
        @TargetApi(value=16)
        public void openFileChooser(ValueCallback<Uri> valueCallback, String acceptType, String capture) {
            if (DWebView.this.webChromeClient instanceof FileChooser) {
                ((FileChooser)DWebView.this.webChromeClient).openFileChooser(valueCallback, acceptType, capture);
            }
        }
    };

    public DWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DWebView(Context context) {
        super(context);
        this.init();
    }

    public static void setWebContentsDebuggingEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)enabled);
        }
        isDebug = enabled;
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.APP_CACHE_DIRNAME = this.getContext().getFilesDir().getAbsolutePath() + "/webcache";
        WebSettings settings = this.getSettings();
        settings.setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies((WebView)this, true);
            settings.setMixedContentMode(0);
        }
        settings.setAllowFileAccess(false);
        settings.setAppCacheEnabled(false);
        settings.setCacheMode(2);
        settings.setJavaScriptEnabled(true);
        settings.setLoadWithOverviewMode(true);
        settings.setAppCachePath(this.APP_CACHE_DIRNAME);
        settings.setUseWideViewPort(true);
        super.setWebChromeClient(this.mWebChromeClient);
        this.addInternalJavascriptObject();
        if (Build.VERSION.SDK_INT > 16) {
            super.addJavascriptInterface((Object)this.innerJavascriptInterface, BRIDGE_NAME);
        } else {
            settings.setUserAgentString(settings.getUserAgentString() + " _dsbridge");
        }
    }

    private String[] parseNamespace(String method) {
        int pos = method.lastIndexOf(46);
        String namespace = "";
        if (pos != -1) {
            namespace = method.substring(0, pos);
            method = method.substring(pos + 1);
        }
        return new String[]{namespace, method};
    }

    @Keep
    private void addInternalJavascriptObject() {
        this.addJavascriptObject(new Object(){

            @JavascriptInterface
            @Keep
            public boolean hasNativeMethod(Object args) throws JSONException {
                JSONObject jsonObject = (JSONObject)args;
                String methodName = jsonObject.getString("name").trim();
                String type = jsonObject.getString("type").trim();
                String[] nameStr = DWebView.this.parseNamespace(methodName);
                Object jsb = DWebView.this.javaScriptNamespaceInterfaces.get(nameStr[0]);
                if (jsb != null) {
                    Class<?> cls = jsb.getClass();
                    boolean asyn = false;
                    Method method = null;
                    try {
                        method = cls.getMethod(nameStr[1], Object.class, CompletionHandler.class);
                        asyn = true;
                    }
                    catch (Exception e) {
                        try {
                            method = cls.getMethod(nameStr[1], Object.class);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (method != null) {
                        JavascriptInterface annotation;
                        if (Build.VERSION.SDK_INT >= 17 && (annotation = method.getAnnotation(JavascriptInterface.class)) == null) {
                            return false;
                        }
                        if ("all".equals(type) || asyn && "asyn".equals(type) || !asyn && "syn".equals(type)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            @JavascriptInterface
            @Keep
            public String closePage(Object object) throws JSONException {
                DWebView.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        Context context;
                        if ((DWebView.this.javascriptCloseWindowListener == null || DWebView.this.javascriptCloseWindowListener.onClose()) && (context = DWebView.this.getContext()) instanceof Activity) {
                            ((Activity)context).onBackPressed();
                        }
                    }
                });
                return null;
            }

            @JavascriptInterface
            @Keep
            public void disableJavascriptDialogBlock(Object object) throws JSONException {
                JSONObject jsonObject = (JSONObject)object;
                DWebView.this.alertBoxBlock = !jsonObject.getBoolean("disable");
            }

            @JavascriptInterface
            @Keep
            public void dsinit(Object jsonObject) {
                DWebView.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        DWebView.this.dispatchStartupQueue();
                    }
                });
            }

            @JavascriptInterface
            @Keep
            public void returnValue(final Object obj) {
                DWebView.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        JSONObject jsonObject = (JSONObject)obj;
                        Object data = null;
                        try {
                            int id = jsonObject.getInt("id");
                            boolean isCompleted = jsonObject.getBoolean("complete");
                            OnReturnValue handler = DWebView.this.handlerMap.get(id);
                            if (jsonObject.has("data")) {
                                data = jsonObject.get("data");
                            }
                            if (handler != null) {
                                handler.onValue(data);
                                if (isCompleted) {
                                    DWebView.this.handlerMap.remove(id);
                                }
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }, "_dsb");
    }

    private void _evaluateJavascript(String script) {
        if (Build.VERSION.SDK_INT >= 19) {
            DWebView.super.evaluateJavascript(script, null);
        } else {
            super.loadUrl("javascript:" + script);
        }
    }

    public void evaluateJavascript(final String script) {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                DWebView.this._evaluateJavascript(script);
            }
        });
    }

    public void loadUrl(final String url) {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (url != null && url.startsWith("javascript:")) {
                    DWebView.super.loadUrl(url);
                } else {
                    DWebView.this.callInfoList = new ArrayList();
                    DWebView.super.loadUrl(url);
                }
            }
        });
    }

    public void loadUrl(final String url, final Map<String, String> additionalHttpHeaders) {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (url != null && url.startsWith("javascript:")) {
                    DWebView.super.loadUrl(url, additionalHttpHeaders);
                } else {
                    DWebView.this.callInfoList = new ArrayList();
                    DWebView.super.loadUrl(url, additionalHttpHeaders);
                }
            }
        });
    }

    public void reload() {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                DWebView.this.callInfoList = new ArrayList();
                DWebView.super.reload();
            }
        });
    }

    public void setJavascriptCloseWindowListener(JavascriptCloseWindowListener listener) {
        this.javascriptCloseWindowListener = listener;
    }

    private synchronized void dispatchStartupQueue() {
        if (this.callInfoList != null) {
            for (CallInfo info : this.callInfoList) {
                this.dispatchJavascriptCall(info);
            }
            this.callInfoList = null;
        }
    }

    private void dispatchJavascriptCall(CallInfo info) {
        this.evaluateJavascript(String.format("window._handleMessageFromNative(%s)", info.toString()));
    }

    public synchronized <T> void callHandler(String method, Object[] args, OnReturnValue<T> handler) {
        CallInfo callInfo = new CallInfo(method, ++this.callID, args);
        if (handler != null) {
            this.handlerMap.put(callInfo.callbackId, handler);
        }
        if (this.callInfoList != null) {
            this.callInfoList.add(callInfo);
        } else {
            this.dispatchJavascriptCall(callInfo);
        }
    }

    public void callHandler(String method, Object[] args) {
        this.callHandler(method, args, null);
    }

    public <T> void callHandler(String method, OnReturnValue<T> handler) {
        this.callHandler(method, null, handler);
    }

    public void hasJavascriptMethod(String handlerName, OnReturnValue<Boolean> existCallback) {
        this.callHandler("_hasJavascriptMethod", new Object[]{handlerName}, existCallback);
    }

    public void addJavascriptObject(Object object, String namespace) {
        if (namespace == null) {
            namespace = "";
        }
        if (object != null) {
            this.javaScriptNamespaceInterfaces.put(namespace, object);
        }
    }

    public void removeJavascriptObject(String namespace) {
        if (namespace == null) {
            namespace = "";
        }
        this.javaScriptNamespaceInterfaces.remove(namespace);
    }

    public void disableJavascriptDialogBlock(boolean disable) {
        this.alertBoxBlock = !disable;
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.webChromeClient = client;
    }

    public void clearCache(boolean includeDiskFiles) {
        super.clearCache(includeDiskFiles);
        CookieManager.getInstance().removeAllCookie();
        Context context = this.getContext();
        try {
            context.deleteDatabase("webview.db");
            context.deleteDatabase("webviewCache.db");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File appCacheDir = new File(this.APP_CACHE_DIRNAME);
        File webviewCacheDir = new File(context.getCacheDir().getAbsolutePath() + "/webviewCache");
        if (webviewCacheDir.exists()) {
            this.deleteFile(webviewCacheDir);
        }
        if (appCacheDir.exists()) {
            this.deleteFile(appCacheDir);
        }
    }

    public void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.deleteFile(files[i]);
                }
            }
            file.delete();
        } else {
            Log.e((String)"Webview", (String)("delete file no exists " + file.getAbsolutePath()));
        }
    }

    private void runOnMainThread(Runnable runnable) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            runnable.run();
            return;
        }
        this.mainHandler.post(runnable);
    }

    private static class CallInfo {
        private String data;
        private int callbackId;
        private String method;

        CallInfo(String handlerName, int id, Object[] args) {
            if (args == null) {
                args = new Object[]{};
            }
            this.data = new JSONArray(Arrays.asList(args)).toString();
            this.callbackId = id;
            this.method = handlerName;
        }

        public String toString() {
            JSONObject jo = new JSONObject();
            try {
                jo.put("method", (Object)this.method);
                jo.put("callbackId", this.callbackId);
                jo.put("data", (Object)this.data);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return jo.toString();
        }
    }

    @Deprecated
    public static interface FileChooser {
        @TargetApi(value=11)
        public void openFileChooser(ValueCallback var1, String var2);

        @TargetApi(value=16)
        public void openFileChooser(ValueCallback<Uri> var1, String var2, String var3);
    }

    public static interface JavascriptCloseWindowListener {
        public boolean onClose();
    }

    private class InnerJavascriptInterface {
        private InnerJavascriptInterface() {
        }

        private void PrintDebugInfo(String error) {
            if (isDebug) {
                Log.e((String)DWebView.LOG_TAG, (String)("dsBridge DEBUG ERR MSG:\\n" + error.replaceAll("'", "\\\\'")));
            }
        }

        @JavascriptInterface
        @Keep
        public String call(String methodName, String argStr) {
            JavascriptInterface annotation;
            String error = "Js bridge  called, but can't find a corresponded JavascriptInterface object , please check your code!";
            String[] nameStr = DWebView.this.parseNamespace(methodName.trim());
            methodName = nameStr[1];
            Object jsb = DWebView.this.javaScriptNamespaceInterfaces.get(nameStr[0]);
            JSONObject ret = new JSONObject();
            try {
                ret.put("code", -1);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (jsb == null) {
                this.PrintDebugInfo(error);
                return ret.toString();
            }
            Object arg = null;
            Method method = null;
            String callback = null;
            try {
                JSONObject args = new JSONObject(argStr);
                if (args.has("_dscbstub")) {
                    callback = args.getString("_dscbstub");
                }
                if (args.has("data")) {
                    arg = args.get("data");
                }
            }
            catch (JSONException e) {
                error = String.format("The argument of \"%s\" must be a JSON object string!", methodName);
                this.PrintDebugInfo(error);
                e.printStackTrace();
                return ret.toString();
            }
            Class<?> cls = jsb.getClass();
            boolean asyn = false;
            try {
                method = cls.getMethod(methodName, Object.class, CompletionHandler.class);
                asyn = true;
            }
            catch (Exception e) {
                try {
                    method = cls.getMethod(methodName, Object.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (method == null) {
                error = "Not find method \"" + methodName + "\" implementation! please check if the  signature or namespace of the method is right ";
                this.PrintDebugInfo(error);
                return ret.toString();
            }
            if (Build.VERSION.SDK_INT >= 17 && (annotation = method.getAnnotation(JavascriptInterface.class)) == null) {
                error = "Method " + methodName + " is not invoked, since  it is not declared with JavascriptInterface annotation! ";
                this.PrintDebugInfo(error);
                return ret.toString();
            }
            method.setAccessible(true);
            try {
                if (!asyn) {
                    Object retData = method.invoke(jsb, arg);
                    ret.put("code", 0);
                    ret.put("data", retData);
                    return ret.toString();
                }
                final String cb = callback;
                method.invoke(jsb, arg, new CompletionHandler(){

                    public void complete(Object retValue) {
                        this.complete(retValue, true);
                    }

                    @Override
                    public void complete() {
                        this.complete(null, true);
                    }

                    public void setProgressData(Object value) {
                        this.complete(value, false);
                    }

                    private void complete(Object retValue, boolean complete) {
                        try {
                            JSONObject ret = new JSONObject();
                            ret.put("code", 0);
                            ret.put("data", retValue);
                            if (cb != null) {
                                String script = String.format("%s(%s.data);", cb, ret.toString());
                                if (complete) {
                                    script = script + "delete window." + cb;
                                }
                                DWebView.this.evaluateJavascript(script);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                error = String.format("Call failed\uff1aThe parameter of \"%s\" in Java is invalid.", methodName);
                this.PrintDebugInfo(error);
                return ret.toString();
            }
            return ret.toString();
        }
    }
}

