/*
 * Decompiled with CFR 0.152.
 */
package wendu.dsbridge;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Keep;
import android.support.v7.app.AlertDialog;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.GeolocationPermissions;
import android.webkit.JavascriptInterface;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.FrameLayout;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import wendu.dsbridge.CompletionHandler;
import wendu.dsbridge.OnReturnValue;

public class DWebView
extends WebView {
    private static final String BRIDGE_NAME = "_dsbridge";
    private static final String LOG_TAG = "dsBridge";
    private static boolean isDebug = false;
    private Map<String, Object> javaScriptNamespaceInterfaces = new HashMap<String, Object>();
    private String APP_CACHE_DIRNAME;
    int callID = 0;
    private static final int EXEC_SCRIPT = 1;
    private static final int LOAD_URL = 2;
    private static final int LOAD_URL_WITH_HEADERS = 3;
    private static final int JS_CLOSE_WINDOW = 4;
    private static final int JS_RETURN_VALUE = 5;
    WebChromeClient webChromeClient;
    MyHandler mainThreadHandler = null;
    private volatile boolean alertboxBlock = true;
    private JavascriptCloseWindowListener javascriptCloseWindowListener = null;
    private ArrayList<CallInfo> callInfoList = new ArrayList();
    Map<Integer, OnReturnValue> handlerMap = new HashMap<Integer, OnReturnValue>();
    private WebChromeClient mWebChromeClient = new WebChromeClient(){

        public void onProgressChanged(WebView view, int newProgress) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onProgressChanged(view, newProgress);
            } else {
                super.onProgressChanged(view, newProgress);
            }
        }

        public void onReceivedTitle(WebView view, String title) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onReceivedTitle(view, title);
            } else {
                super.onReceivedTitle(view, title);
            }
        }

        public void onReceivedIcon(WebView view, Bitmap icon) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onReceivedIcon(view, icon);
            } else {
                super.onReceivedIcon(view, icon);
            }
        }

        public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onReceivedTouchIconUrl(view, url, precomposed);
            } else {
                super.onReceivedTouchIconUrl(view, url, precomposed);
            }
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onShowCustomView(view, callback);
            } else {
                super.onShowCustomView(view, callback);
            }
        }

        public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onShowCustomView(view, requestedOrientation, callback);
            } else {
                super.onShowCustomView(view, requestedOrientation, callback);
            }
        }

        public void onHideCustomView() {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onHideCustomView();
            } else {
                super.onHideCustomView();
            }
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
            }
            return super.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
        }

        public void onRequestFocus(WebView view) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onRequestFocus(view);
            } else {
                super.onRequestFocus(view);
            }
        }

        public void onCloseWindow(WebView window) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onCloseWindow(window);
            } else {
                super.onCloseWindow(window);
            }
        }

        public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
            if (!DWebView.this.alertboxBlock) {
                result.confirm();
            }
            if (DWebView.this.webChromeClient != null && DWebView.this.webChromeClient.onJsAlert(view, url, message, result)) {
                return true;
            }
            AlertDialog alertDialog = new AlertDialog.Builder(DWebView.this.getContext()).setMessage((CharSequence)message).setCancelable(false).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    if (DWebView.this.alertboxBlock) {
                        result.confirm();
                    }
                }
            }).create();
            alertDialog.show();
            return true;
        }

        public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
            if (!DWebView.this.alertboxBlock) {
                result.confirm();
            }
            if (DWebView.this.webChromeClient != null && DWebView.this.webChromeClient.onJsConfirm(view, url, message, result)) {
                return true;
            }
            DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (DWebView.this.alertboxBlock) {
                        if (which == -1) {
                            result.confirm();
                        } else {
                            result.cancel();
                        }
                    }
                }
            };
            new AlertDialog.Builder(DWebView.this.getContext()).setMessage((CharSequence)message).setCancelable(false).setPositiveButton(17039370, listener).setNegativeButton(0x1040000, listener).show();
            return true;
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, final JsPromptResult result) {
            if (!DWebView.this.alertboxBlock) {
                result.confirm();
            }
            if (DWebView.this.webChromeClient != null && DWebView.this.webChromeClient.onJsPrompt(view, url, message, defaultValue, result)) {
                return true;
            }
            final EditText editText = new EditText(DWebView.this.getContext());
            editText.setText((CharSequence)defaultValue);
            if (defaultValue != null) {
                editText.setSelection(defaultValue.length());
            }
            float dpi = DWebView.this.getContext().getResources().getDisplayMetrics().density;
            DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (DWebView.this.alertboxBlock) {
                        if (which == -1) {
                            result.confirm(editText.getText().toString());
                        } else {
                            result.cancel();
                        }
                    }
                }
            };
            new AlertDialog.Builder(DWebView.this.getContext()).setTitle((CharSequence)message).setView((View)editText).setCancelable(false).setPositiveButton(17039370, listener).setNegativeButton(0x1040000, listener).show();
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
            int t = (int)(dpi * 16.0f);
            layoutParams.setMargins(t, 0, t, 0);
            layoutParams.gravity = 1;
            editText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            int padding = (int)(15.0f * dpi);
            editText.setPadding(padding - (int)(5.0f * dpi), padding, padding, padding);
            return true;
        }

        public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.onJsBeforeUnload(view, url, message, result);
            }
            return super.onJsBeforeUnload(view, url, message, result);
        }

        public void onExceededDatabaseQuota(String url, String databaseIdentifier, long quota, long estimatedDatabaseSize, long totalQuota, WebStorage.QuotaUpdater quotaUpdater) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onExceededDatabaseQuota(url, databaseIdentifier, quota, estimatedDatabaseSize, totalQuota, quotaUpdater);
            } else {
                super.onExceededDatabaseQuota(url, databaseIdentifier, quota, estimatedDatabaseSize, totalQuota, quotaUpdater);
            }
        }

        public void onReachedMaxAppCacheSize(long requiredStorage, long quota, WebStorage.QuotaUpdater quotaUpdater) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onReachedMaxAppCacheSize(requiredStorage, quota, quotaUpdater);
            }
            super.onReachedMaxAppCacheSize(requiredStorage, quota, quotaUpdater);
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onGeolocationPermissionsShowPrompt(origin, callback);
            } else {
                super.onGeolocationPermissionsShowPrompt(origin, callback);
            }
        }

        public void onGeolocationPermissionsHidePrompt() {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onGeolocationPermissionsHidePrompt();
            } else {
                super.onGeolocationPermissionsHidePrompt();
            }
        }

        @TargetApi(value=21)
        public void onPermissionRequest(PermissionRequest request) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onPermissionRequest(request);
            } else {
                super.onPermissionRequest(request);
            }
        }

        @TargetApi(value=21)
        public void onPermissionRequestCanceled(PermissionRequest request) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onPermissionRequestCanceled(request);
            } else {
                super.onPermissionRequestCanceled(request);
            }
        }

        public boolean onJsTimeout() {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.onJsTimeout();
            }
            return super.onJsTimeout();
        }

        public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.onConsoleMessage(message, lineNumber, sourceID);
            } else {
                super.onConsoleMessage(message, lineNumber, sourceID);
            }
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.onConsoleMessage(consoleMessage);
            }
            return super.onConsoleMessage(consoleMessage);
        }

        public Bitmap getDefaultVideoPoster() {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.getDefaultVideoPoster();
            }
            return super.getDefaultVideoPoster();
        }

        public View getVideoLoadingProgressView() {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.getVideoLoadingProgressView();
            }
            return super.getVideoLoadingProgressView();
        }

        public void getVisitedHistory(ValueCallback<String[]> callback) {
            if (DWebView.this.webChromeClient != null) {
                DWebView.this.webChromeClient.getVisitedHistory(callback);
            } else {
                super.getVisitedHistory(callback);
            }
        }

        @TargetApi(value=21)
        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            if (DWebView.this.webChromeClient != null) {
                return DWebView.this.webChromeClient.onShowFileChooser(webView, filePathCallback, fileChooserParams);
            }
            return super.onShowFileChooser(webView, filePathCallback, fileChooserParams);
        }
    };

    public DWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DWebView(Context context) {
        super(context);
        this.init();
    }

    public static void setWebContentsDebuggingEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)enabled);
        }
        isDebug = enabled;
    }

    @Keep
    void init() {
        this.mainThreadHandler = new MyHandler((Activity)this.getContext());
        this.APP_CACHE_DIRNAME = this.getContext().getFilesDir().getAbsolutePath() + "/webcache";
        WebSettings settings = this.getSettings();
        settings.setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies((WebView)this, true);
            settings.setMixedContentMode(0);
        }
        settings.setAllowFileAccess(false);
        settings.setAppCacheEnabled(false);
        settings.setCacheMode(2);
        settings.setJavaScriptEnabled(true);
        settings.setLoadWithOverviewMode(true);
        settings.setSupportMultipleWindows(true);
        settings.setAppCachePath(this.APP_CACHE_DIRNAME);
        settings.setUseWideViewPort(true);
        super.setWebChromeClient(this.mWebChromeClient);
        this.addInternalJavascriptObject();
        super.addJavascriptInterface(new Object(){

            private void PrintDebugInfo(String error) {
                Log.d((String)DWebView.LOG_TAG, (String)error);
                if (isDebug) {
                    DWebView.this.evaluateJavascript(String.format("alert('%s')", "DEBUG ERR MSG:\\n" + error.replaceAll("\\'", "\\\\'")));
                }
            }

            @JavascriptInterface
            @Keep
            public String call(String methodName, String argStr) throws JSONException {
                Object arg;
                String error = "Js bridge  called, but can't find a corresponded JavascriptInterface object , please check your code!";
                String[] nameStr = DWebView.this.parseNamespace(methodName.trim());
                methodName = nameStr[1];
                Object jsb = DWebView.this.javaScriptNamespaceInterfaces.get(nameStr[0]);
                JSONObject ret = new JSONObject();
                ret.put("code", -1);
                if (jsb == null) {
                    this.PrintDebugInfo(error);
                    return ret.toString();
                }
                Method method = null;
                String callback = null;
                try {
                    JSONObject args = new JSONObject(argStr);
                    if (args.has("_dscbstub")) {
                        callback = args.getString("_dscbstub");
                    }
                    arg = args.get("data");
                }
                catch (JSONException e) {
                    error = String.format("The argument of \"%s\" must be a JSON object string!", methodName);
                    this.PrintDebugInfo(error);
                    e.printStackTrace();
                    return ret.toString();
                }
                Class<?> cls = jsb.getClass();
                boolean asyn = false;
                try {
                    method = cls.getDeclaredMethod(methodName, Object.class, CompletionHandler.class);
                    asyn = true;
                }
                catch (Exception e) {
                    try {
                        method = cls.getDeclaredMethod(methodName, Object.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (method == null) {
                    error = "Not find method \"" + methodName + "\" implementation! please check if the  signature or namespace of the method is right ";
                    this.PrintDebugInfo(error);
                    return ret.toString();
                }
                JavascriptInterface annotation = method.getAnnotation(JavascriptInterface.class);
                if (annotation == null) {
                    error = "Method " + methodName + " is not invoked, since  it is not declared with JavascriptInterface annotation! ";
                    this.PrintDebugInfo(error);
                    return ret.toString();
                }
                method.setAccessible(true);
                try {
                    if (!asyn) {
                        Object retData = method.invoke(jsb, arg);
                        ret.put("code", 0);
                        ret.put("data", retData);
                        return ret.toString();
                    }
                    final String cb = callback;
                    method.invoke(jsb, arg, new CompletionHandler(){

                        public void complete(Object retValue) {
                            this.complete(retValue, true);
                        }

                        @Override
                        public void complete() {
                            this.complete(null, true);
                        }

                        public void setProgressData(Object value) {
                            this.complete(value, false);
                        }

                        private void complete(Object retValue, boolean complete) {
                            try {
                                JSONObject ret = new JSONObject();
                                ret.put("code", 0);
                                ret.put("data", retValue);
                                if (cb != null) {
                                    String script = String.format("%s(%s.data);", cb, ret.toString());
                                    if (complete) {
                                        script = script + "delete window." + cb;
                                    }
                                    DWebView.this.evaluateJavascript(script);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error = String.format("Call failed\uff1aThe parameter of \"%s\" in Java is invalid.", methodName);
                    this.PrintDebugInfo(error);
                    return ret.toString();
                }
                return ret.toString();
            }
        }, BRIDGE_NAME);
    }

    private String[] parseNamespace(String method) {
        int pos = method.lastIndexOf(46);
        String namespace = "";
        if (pos != -1) {
            namespace = method.substring(0, pos);
            method = method.substring(pos + 1);
        }
        return new String[]{namespace, method};
    }

    @Keep
    private void addInternalJavascriptObject() {
        this.addJavascriptObject(new Object(){

            @JavascriptInterface
            @Keep
            public boolean hasNativeMethod(Object args) throws JSONException {
                JSONObject jsonObject = (JSONObject)args;
                String methodName = jsonObject.getString("name").trim();
                String type = jsonObject.getString("type").trim();
                String[] nameStr = DWebView.this.parseNamespace(methodName);
                Object jsb = DWebView.this.javaScriptNamespaceInterfaces.get(nameStr[0]);
                if (jsb != null) {
                    JavascriptInterface annotation;
                    Class<?> cls = jsb.getClass();
                    boolean asyn = false;
                    Method method = null;
                    try {
                        method = cls.getDeclaredMethod(nameStr[1], Object.class, CompletionHandler.class);
                        asyn = true;
                    }
                    catch (Exception e) {
                        try {
                            method = cls.getDeclaredMethod(nameStr[1], Object.class);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (method != null && (annotation = method.getAnnotation(JavascriptInterface.class)) != null && ("all".equals(type) || asyn && "asyn".equals(type) || !asyn && "syn".equals(type))) {
                        return true;
                    }
                }
                return false;
            }

            @JavascriptInterface
            @Keep
            public String closePage(Object object) throws JSONException {
                Message msg = new Message();
                msg.what = 4;
                DWebView.this.mainThreadHandler.sendMessage(msg);
                return null;
            }

            @JavascriptInterface
            @Keep
            public void disableJavascriptDialogBlock(Object object) throws JSONException {
                JSONObject jsonObject = (JSONObject)object;
                DWebView.this.alertboxBlock = !jsonObject.getBoolean("disable");
            }

            @JavascriptInterface
            @Keep
            public void dsinit(Object jsonObject) {
                DWebView.this.dispatchStartupQueue();
            }

            @JavascriptInterface
            @Keep
            public void returnValue(Object obj) throws JSONException {
                JSONObject jsonObject = (JSONObject)obj;
                Message msg = new Message();
                msg.what = 5;
                msg.arg1 = jsonObject.getInt("id");
                int n = msg.arg2 = jsonObject.getBoolean("complete") ? 1 : 0;
                if (jsonObject.has("data")) {
                    msg.obj = jsonObject.get("data");
                }
                DWebView.this.mainThreadHandler.sendMessage(msg);
            }
        }, "_dsb");
    }

    private void _evaluateJavascript(String script) {
        if (Build.VERSION.SDK_INT >= 19) {
            DWebView.super.evaluateJavascript(script, null);
        } else {
            this.loadUrl("javascript:" + script);
        }
    }

    public void evaluateJavascript(String script) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this._evaluateJavascript(script);
        } else {
            Message msg = new Message();
            msg.what = 1;
            msg.obj = script;
            this.mainThreadHandler.sendMessage(msg);
        }
    }

    public void loadUrl(String url) {
        Message msg = new Message();
        msg.what = 2;
        msg.obj = url;
        this.mainThreadHandler.sendMessage(msg);
    }

    public void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        Message msg = new Message();
        msg.what = 3;
        msg.obj = new RequestInfo(url, additionalHttpHeaders);
        this.mainThreadHandler.sendMessage(msg);
    }

    public void setJavascriptCloseWindowListener(JavascriptCloseWindowListener listener) {
        this.javascriptCloseWindowListener = listener;
    }

    private synchronized void dispatchStartupQueue() {
        for (CallInfo info : this.callInfoList) {
            this.dispatchJavascriptCall(info);
        }
        this.callInfoList = null;
    }

    private void dispatchJavascriptCall(CallInfo info) {
        this.evaluateJavascript(String.format("window._handleMessageFromNative(%s)", info.toString()));
    }

    public synchronized <T> void callHandler(String method, Object[] args, OnReturnValue<T> handler) {
        CallInfo callInfo = new CallInfo(method, this.callID, args);
        if (handler != null) {
            this.handlerMap.put(this.callID++, handler);
        }
        if (this.callInfoList != null) {
            this.callInfoList.add(callInfo);
        } else {
            this.dispatchJavascriptCall(callInfo);
        }
    }

    public void callHandler(String method, Object[] args) {
        this.callHandler(method, args, null);
    }

    public <T> void callHandler(String method, OnReturnValue<T> handler) {
        this.callHandler(method, null, handler);
    }

    public void hasJavascriptMethod(String handlerName, OnReturnValue<Boolean> existCallback) {
        this.callHandler("_hasJavascriptMethod", new Object[]{handlerName}, existCallback);
    }

    public void addJavascriptObject(Object object, String namespace) {
        if (namespace == null) {
            namespace = "";
        }
        if (object != null) {
            this.javaScriptNamespaceInterfaces.put(namespace, object);
        }
    }

    public void removeJavascriptObject(String namespace) {
        if (namespace == null) {
            namespace = "";
        }
        this.javaScriptNamespaceInterfaces.remove(namespace);
    }

    public void disableJavascriptDialogBlock(boolean disable) {
        this.alertboxBlock = !disable;
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.webChromeClient = client;
    }

    public void clearCache(boolean includeDiskFiles) {
        super.clearCache(includeDiskFiles);
        CookieManager.getInstance().removeAllCookie();
        Context context = this.getContext();
        try {
            context.deleteDatabase("webview.db");
            context.deleteDatabase("webviewCache.db");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File appCacheDir = new File(this.APP_CACHE_DIRNAME);
        File webviewCacheDir = new File(context.getCacheDir().getAbsolutePath() + "/webviewCache");
        if (webviewCacheDir.exists()) {
            this.deleteFile(webviewCacheDir);
        }
        if (appCacheDir.exists()) {
            this.deleteFile(appCacheDir);
        }
    }

    public void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.deleteFile(files[i]);
                }
            }
            file.delete();
        } else {
            Log.e((String)"Webview", (String)("delete file no exists " + file.getAbsolutePath()));
        }
    }

    private class CallInfo {
        public String data = null;
        public int callbackId;
        public String method;

        public CallInfo(String handlerName, int id, Object[] args) {
            if (args == null) {
                args = new Object[]{};
            }
            this.data = new JSONArray(Arrays.asList(args)).toString();
            this.callbackId = id;
            this.method = handlerName;
        }

        public String toString() {
            JSONObject jo = new JSONObject();
            try {
                jo.put("method", (Object)this.method);
                jo.put("callbackId", this.callbackId);
                jo.put("data", (Object)this.data);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return jo.toString();
        }
    }

    public static interface JavascriptCloseWindowListener {
        public boolean onClose();
    }

    class RequestInfo {
        String url;
        Map<String, String> headers;

        RequestInfo(String url, Map<String, String> additionalHttpHeaders) {
            this.url = url;
            this.headers = additionalHttpHeaders;
        }
    }

    class MyHandler
    extends Handler {
        WeakReference<Activity> mActivityReference;

        MyHandler(Activity activity) {
            this.mActivityReference = new WeakReference<Activity>(activity);
        }

        public void handleMessage(Message msg) {
            Activity activity = (Activity)this.mActivityReference.get();
            if (activity != null) {
                switch (msg.what) {
                    case 1: {
                        DWebView.this._evaluateJavascript((String)msg.obj);
                        break;
                    }
                    case 2: {
                        DWebView.super.loadUrl((String)msg.obj);
                        break;
                    }
                    case 3: {
                        RequestInfo info = (RequestInfo)msg.obj;
                        DWebView.super.loadUrl(info.url, info.headers);
                        break;
                    }
                    case 4: {
                        if (DWebView.this.javascriptCloseWindowListener != null && !DWebView.this.javascriptCloseWindowListener.onClose()) break;
                        ((Activity)DWebView.this.getContext()).onBackPressed();
                        break;
                    }
                    case 5: {
                        int id = msg.arg1;
                        OnReturnValue handler = DWebView.this.handlerMap.get(id);
                        if (handler == null) break;
                        if (isDebug) {
                            handler.onValue(msg.obj);
                        } else {
                            try {
                                handler.onValue(msg.obj);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (msg.arg2 != 1) break;
                        DWebView.this.handlerMap.remove(id);
                    }
                }
            }
        }
    }
}

