/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.frma;

import com.optimaize.langdetect.cybozu.util.LangProfile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;

public class LangProfileWriter {
    public void write(LangProfile langProfile, OutputStream outputStream) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.forName("utf-8")));){
            writer.write("{\"freq\":{");
            boolean first = true;
            for (Map.Entry<String, Integer> entry : langProfile.getFreq().entrySet()) {
                if (!first) {
                    writer.write(44);
                }
                writer.write(34);
                writer.write(entry.getKey());
                writer.write("\":");
                writer.write(entry.getValue().toString());
                first = false;
            }
            writer.write("},\"n_words\":[");
            first = true;
            for (Object nWord : (Object)langProfile.getNWords()) {
                if (!first) {
                    writer.write(44);
                }
                writer.write(Integer.toString((int)nWord));
                first = false;
            }
            writer.write("],\"name\":\"");
            writer.write(langProfile.getName());
            writer.write("\"}");
            writer.flush();
        }
    }
}

