/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.liveeventbus.ipc.core;

import android.content.Intent;
import android.os.Bundle;
import com.jeremyliao.liveeventbus.ipc.annotation.IpcConfig;
import com.jeremyliao.liveeventbus.ipc.core.BooleanProcessor;
import com.jeremyliao.liveeventbus.ipc.core.DoubleProcessor;
import com.jeremyliao.liveeventbus.ipc.core.FloatProcessor;
import com.jeremyliao.liveeventbus.ipc.core.IntProcessor;
import com.jeremyliao.liveeventbus.ipc.core.LongProcessor;
import com.jeremyliao.liveeventbus.ipc.core.ParcelableProcessor;
import com.jeremyliao.liveeventbus.ipc.core.Processor;
import com.jeremyliao.liveeventbus.ipc.core.SerializableProcessor;
import com.jeremyliao.liveeventbus.ipc.core.StringProcessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProcessorManager {
    private final List<Processor> baseProcessors = new LinkedList<Processor>(Arrays.asList(new StringProcessor(), new IntProcessor(), new BooleanProcessor(), new DoubleProcessor(), new FloatProcessor(), new LongProcessor(), new SerializableProcessor(), new ParcelableProcessor()));
    private final Map<String, Processor> processorMap = new HashMap<String, Processor>();

    public static ProcessorManager getManager() {
        return SingletonHolder.INSTANCE;
    }

    private ProcessorManager() {
        for (Processor processor : this.baseProcessors) {
            this.processorMap.put(processor.getClass().getName(), processor);
        }
    }

    public boolean writeTo(Intent intent, Object value) {
        if (intent == null || value == null) {
            return false;
        }
        Bundle bundle = new Bundle();
        boolean processed = false;
        IpcConfig config = value.getClass().getAnnotation(IpcConfig.class);
        if (config != null) {
            Processor processor;
            Class<? extends Processor> processorType = config.processor();
            String processorTypeName = processorType.getName();
            if (!this.processorMap.containsKey(processorTypeName)) {
                try {
                    this.processorMap.put(processorTypeName, processorType.newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((processor = this.processorMap.get(processorTypeName)) != null) {
                try {
                    boolean handle = processor.writeToBundle(bundle, value);
                    if (handle) {
                        intent.putExtra("leb_ipc_processor_name", processor.getClass().getName());
                        intent.putExtra("leb_ipc_bundle", bundle);
                        processed = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (processed) {
                return true;
            }
        }
        for (Processor processor : this.baseProcessors) {
            try {
                boolean handle = processor.writeToBundle(bundle, value);
                if (!handle) continue;
                intent.putExtra("leb_ipc_processor_name", processor.getClass().getName());
                intent.putExtra("leb_ipc_bundle", bundle);
                processed = true;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return processed;
    }

    public Object createFrom(Intent intent) {
        Processor processor;
        if (intent == null) {
            return null;
        }
        String processorName = intent.getStringExtra("leb_ipc_processor_name");
        Bundle bundle = intent.getBundleExtra("leb_ipc_bundle");
        if (processorName == null || processorName.length() == 0 || bundle == null) {
            return null;
        }
        if (!this.processorMap.containsKey(processorName)) {
            try {
                this.processorMap.put(processorName, (Processor)Class.forName(processorName).newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((processor = this.processorMap.get(processorName)) == null) {
            return null;
        }
        try {
            return processor.createFromBundle(bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class SingletonHolder {
        private static final ProcessorManager INSTANCE = new ProcessorManager();

        private SingletonHolder() {
        }
    }
}

