/*
 * Decompiled with CFR 0.152.
 */
package cn.nekocode.rxlifecycle.compact;

import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import cn.nekocode.rxlifecycle.LifecyclePublisher;
import cn.nekocode.rxlifecycle.compact.BindingV4Fragment;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleCompletableTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleFlowableTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleMaybeTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleObservableTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleSingleTransformer;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.SingleTransformer;

public class RxLifecycleCompact {
    private static final String FRAGMENT_TAG = "_BINDING_V4_FRAGMENT_";
    private final LifecyclePublisher lifecyclePublisher;

    public static RxLifecycleCompact bind(@NonNull AppCompatActivity targetActivity) {
        return RxLifecycleCompact.bind(targetActivity.getSupportFragmentManager());
    }

    public static RxLifecycleCompact bind(@NonNull Fragment targetFragment) {
        return RxLifecycleCompact.bind(targetFragment.getChildFragmentManager());
    }

    public static RxLifecycleCompact bind(@NonNull FragmentManager fragmentManager) {
        BindingV4Fragment fragment = (BindingV4Fragment)fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (fragment == null) {
            fragment = new BindingV4Fragment();
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            transaction.add((Fragment)fragment, FRAGMENT_TAG);
            transaction.commit();
        } else if (fragment.isDetached()) {
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            transaction.attach((Fragment)fragment);
            transaction.commit();
        }
        return RxLifecycleCompact.bind(fragment.getLifecyclePublisher());
    }

    public static RxLifecycleCompact bind(@NonNull LifecyclePublisher lifecyclePublisher) {
        return new RxLifecycleCompact(lifecyclePublisher);
    }

    private RxLifecycleCompact() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    private RxLifecycleCompact(@NonNull LifecyclePublisher lifecyclePublisher) {
        this.lifecyclePublisher = lifecyclePublisher;
    }

    public Flowable<Integer> asFlowable() {
        return this.lifecyclePublisher.getBehavior();
    }

    public Observable<Integer> asObservable() {
        return this.lifecyclePublisher.getBehavior().toObservable();
    }

    public <T> FlowableTransformer<T, T> withFlowable() {
        return new BindLifecycleFlowableTransformer(this.lifecyclePublisher.getBehavior());
    }

    public <T> ObservableTransformer<T, T> withObservable() {
        return new BindLifecycleObservableTransformer(this.lifecyclePublisher.getBehavior());
    }

    public CompletableTransformer withCompletable() {
        return new BindLifecycleCompletableTransformer(this.lifecyclePublisher.getBehavior());
    }

    public <T> SingleTransformer<T, T> withSingle() {
        return new BindLifecycleSingleTransformer(this.lifecyclePublisher.getBehavior());
    }

    public <T> MaybeTransformer<T, T> withMaybe() {
        return new BindLifecycleMaybeTransformer(this.lifecyclePublisher.getBehavior());
    }
}

