/*
 * Decompiled with CFR 0.152.
 */
package com.naskar.fluentquery.converters;

import com.naskar.fluentquery.converters.NativeSQL;
import com.naskar.fluentquery.converters.NativeSQLPredicate;
import com.naskar.fluentquery.converters.NativeSQLResult;
import com.naskar.fluentquery.converters.PredicateProvider;
import com.naskar.fluentquery.impl.Convention;
import com.naskar.fluentquery.impl.HolderInt;
import com.naskar.fluentquery.impl.MethodRecordProxy;
import com.naskar.fluentquery.impl.PredicateImpl;
import java.util.ArrayList;
import java.util.List;

public class NativeSQLWhereImpl {
    private Convention convention;
    private NativeSQL nativeSQL;

    public NativeSQLWhereImpl(NativeSQL nativeSQL) {
        this.nativeSQL = nativeSQL;
    }

    public void setConvention(Convention convention) {
        this.convention = convention;
    }

    public <T, I, B> void convertWhere(StringBuilder sb, HolderInt level, String alias, MethodRecordProxy<T> proxy, List<String> parents, List<PredicateImpl<T, Object, I, B>> predicates, NativeSQLResult result) {
        ArrayList conditions = new ArrayList();
        ArrayList conditionTypes = new ArrayList();
        predicates.stream().forEach(p -> {
            if (p.getType() == PredicateImpl.Type.SPEC_AND || p.getType() == PredicateImpl.Type.SPEC_OR) {
                StringBuilder sbSpec = new StringBuilder("");
                PredicateProvider q = (PredicateProvider)p.getProperty().apply(null);
                this.convertWhere(sbSpec, level, alias, proxy, parents, q.getPredicates(), result);
                if (sbSpec.length() > 0) {
                    sbSpec.insert(0, "(");
                    sbSpec.append(")");
                    conditions.add(sbSpec);
                    conditionTypes.add(p.getType());
                }
            } else {
                proxy.clear();
                p.getProperty().apply(proxy.getProxy());
                String name = alias + this.convention.getNameFromMethod(proxy.getMethods());
                p.getActions().forEach(action -> {
                    NativeSQLPredicate predicate = new NativeSQLPredicate(this.nativeSQL, proxy, name, result);
                    predicate.setAlias(alias);
                    predicate.setLevel(level);
                    predicate.setParents(parents);
                    action.accept(predicate);
                    predicate.getConditions().stream().forEach(cond -> {
                        conditions.add(cond);
                        conditionTypes.add(p.getType());
                    });
                });
            }
        });
        if (sb.length() > 0) {
            this.appendType(sb, (PredicateImpl.Type)((Object)conditionTypes.get(0)));
        }
        for (int i = 0; i < conditions.size(); ++i) {
            if (i > 0) {
                this.appendType(sb, (PredicateImpl.Type)((Object)conditionTypes.get(i)));
            }
            sb.append((CharSequence)conditions.get(i));
        }
    }

    private void appendType(StringBuilder sb, PredicateImpl.Type t) {
        if (PredicateImpl.Type.AND == t || PredicateImpl.Type.SPEC_AND == t) {
            sb.append(" and ");
        } else if (PredicateImpl.Type.OR == t || PredicateImpl.Type.SPEC_OR == t) {
            sb.append(" or ");
        }
    }
}

