/*
 * Decompiled with CFR 0.152.
 */
package com.naskar.fluentquery.converters;

import com.naskar.fluentquery.Join;
import com.naskar.fluentquery.Predicate;
import com.naskar.fluentquery.Query;
import com.naskar.fluentquery.QueryBuilder;
import com.naskar.fluentquery.converters.NativeSQL;
import com.naskar.fluentquery.converters.NativeSQLResult;
import com.naskar.fluentquery.impl.HolderInt;
import com.naskar.fluentquery.impl.MethodRecordProxy;
import com.naskar.fluentquery.impl.QueryImpl;
import java.util.ArrayList;
import java.util.List;

class NativeSQLPredicate<T, R, I>
implements Predicate<T, R, I> {
    private NativeSQL nativeSQL;
    private MethodRecordProxy<T> proxy;
    private String name;
    private NativeSQLResult result;
    private String alias;
    private HolderInt level;
    private List<String> parents;
    private List<StringBuilder> conditions;

    public NativeSQLPredicate(NativeSQL nativeSQL, MethodRecordProxy<T> proxy, String name, NativeSQLResult result) {
        this.nativeSQL = nativeSQL;
        this.proxy = proxy;
        this.name = name;
        this.result = result;
        this.conditions = new ArrayList<StringBuilder>();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setLevel(HolderInt level) {
        this.level = level;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }

    private StringBuilder appendValue(String op, R value) {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(op);
        if (value == null && this.parents != null && !this.parents.isEmpty()) {
            sb.append(this.parents.remove(0));
        } else {
            String p = this.result.add(value);
            sb.append(":");
            sb.append(p);
        }
        return sb;
    }

    public List<StringBuilder> getConditions() {
        return this.conditions;
    }

    @Override
    public I eq(R value) {
        this.conditions.add(this.appendValue(" = ", value));
        return null;
    }

    @Override
    public I ne(R value) {
        this.conditions.add(this.appendValue(" <> ", value));
        return null;
    }

    @Override
    public I gt(R value) {
        this.conditions.add(this.appendValue(" > ", value));
        return null;
    }

    @Override
    public I ge(R value) {
        this.conditions.add(this.appendValue(" >= ", value));
        return null;
    }

    @Override
    public I lt(R value) {
        this.conditions.add(this.appendValue(" < ", value));
        return null;
    }

    @Override
    public I le(R value) {
        this.conditions.add(this.appendValue(" <= ", value));
        return null;
    }

    @Override
    public I like(R value) {
        this.conditions.add(this.appendValue(" like ", value));
        return null;
    }

    @Override
    public I isNull() {
        this.conditions.add(new StringBuilder(this.name).append(" is null "));
        return null;
    }

    @Override
    public I isNotNull() {
        this.conditions.add(new StringBuilder(this.name).append(" is not null "));
        return null;
    }

    @Override
    public <J> I in(Class<J> clazz, Join<J, T> action) {
        NativeSQLResult result = this.toSQL(clazz, action);
        this.conditions.add(new StringBuilder(this.name).append(" in (").append(this.result.addResult(result)).append(")"));
        return null;
    }

    @Override
    public <J> I notIn(Class<J> clazz, Join<J, T> action) {
        NativeSQLResult result = this.toSQL(clazz, action);
        this.conditions.add(new StringBuilder(this.name).append(" not in (").append(this.result.addResult(result)).append(")"));
        return null;
    }

    private <J> NativeSQLResult toSQL(Class<J> clazz, Join<J, T> action) {
        Query<J> q = new QueryBuilder().from(clazz);
        QueryImpl qi = (QueryImpl)q;
        HolderInt newLevel = new HolderInt();
        newLevel.value = (this.level.value + 1) * 1000;
        this.proxy.clear();
        action.accept(q, this.proxy.getProxy());
        List<String> parentsTemp = this.nativeSQL.createParents(this.alias, this.proxy);
        return this.nativeSQL.convert(qi, parentsTemp, newLevel);
    }
}

