/*
 * Decompiled with CFR 0.152.
 */
package com.naskar.fluentquery.impl;

import com.naskar.fluentquery.Predicate;
import com.naskar.fluentquery.Query;
import com.naskar.fluentquery.Whereable;
import com.naskar.fluentquery.converters.PredicateProvider;
import com.naskar.fluentquery.impl.PredicateImpl;
import com.naskar.fluentquery.impl.QueryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class WhereImpl<T, I, B>
implements Whereable<T, I>,
PredicateProvider<T, B> {
    private Class<T> clazz;
    private List<PredicateImpl<T, Object, I, B>> predicates;

    public WhereImpl(Class<T> clazz) {
        this.clazz = clazz;
        this.predicates = new ArrayList<PredicateImpl<T, Object, I, B>>();
    }

    @Override
    public List<PredicateImpl<T, Object, I, B>> getPredicates() {
        return this.predicates;
    }

    @Override
    public <R> Predicate<T, R, I> where(Function<T, R> property) {
        return this.and(property);
    }

    @Override
    public I whereSpec(Consumer<Query<T>> query) {
        this.addSpec(query, PredicateImpl.Type.SPEC_AND);
        return (I)this;
    }

    private void addSpec(Consumer<Query<T>> query, PredicateImpl.Type type) {
        PredicateImpl p = new PredicateImpl(this, i -> {
            QueryImpl<T> queryImpl = new QueryImpl<T>(this.clazz);
            query.accept(queryImpl);
            return queryImpl;
        }, type);
        this.predicates.add(p);
    }

    @Override
    public <R> Predicate<T, R, I> and(Function<T, R> property) {
        PredicateImpl p = new PredicateImpl(this, property, PredicateImpl.Type.AND);
        this.predicates.add(p);
        return p;
    }

    @Override
    public <R> Predicate<T, R, I> andIf(Supplier<Boolean> callIf, Function<T, R> property) {
        PredicateImpl p = new PredicateImpl(this, property, PredicateImpl.Type.AND);
        if (callIf.get().booleanValue()) {
            this.predicates.add(p);
        }
        return p;
    }

    @Override
    public I andSpec(Consumer<Query<T>> query) {
        this.addSpec(query, PredicateImpl.Type.SPEC_AND);
        return (I)this;
    }

    @Override
    public <R> Predicate<T, R, I> or(Function<T, R> property) {
        PredicateImpl p = new PredicateImpl(this, property, PredicateImpl.Type.OR);
        this.predicates.add(p);
        return p;
    }

    @Override
    public I orSpec(Consumer<Query<T>> query) {
        this.addSpec(query, PredicateImpl.Type.SPEC_OR);
        return (I)this;
    }
}

